/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleReferenceClassLoader;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.SystemPaths;

public class FrameworkModuleProviderImpl
implements FrameworkModuleProvider {
    private final BundleManagerPlugin bundleManager;
    private final SystemPaths systemPaths;
    private Module frameworkModule;

    public FrameworkModuleProviderImpl(BundleManager bundleManager, SystemPaths systemPaths) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
        this.systemPaths = systemPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Module getFrameworkModule() {
        FrameworkModuleProviderImpl frameworkModuleProviderImpl = this;
        synchronized (frameworkModuleProviderImpl) {
            if (this.frameworkModule == null) {
                this.frameworkModule = this.createFrameworkModule();
            }
            return this.frameworkModule;
        }
    }

    private Module createFrameworkModule() {
        Module frameworkModule;
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)FrameworkModuleProvider.FRAMEWORK_MODULE_IDENTIFIER);
        Set<String> bootPaths = this.systemPaths.getBootDelegationPaths();
        PathFilter bootFilter = this.systemPaths.getBootDelegationFilter();
        PathFilter acceptAll = PathFilters.acceptAll();
        specBuilder.addDependency(DependencySpec.createSystemDependencySpec((PathFilter)bootFilter, (PathFilter)acceptAll, bootPaths));
        final ClassLoader classLoader = BundleManagerPlugin.class.getClassLoader();
        LocalLoader localLoader = new LocalLoader(){

            public Class<?> loadClassLocal(String name, boolean resolve) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public Package loadPackageLocal(String name) {
                throw new UnsupportedOperationException();
            }

            public List<Resource> loadResourceLocal(String name) {
                return Collections.emptyList();
            }
        };
        Set<String> paths = this.systemPaths.getSystemPaths();
        PathFilter filter = this.systemPaths.getSystemFilter();
        SystemBundleState systemBundle = this.bundleManager.getSystemBundle();
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)filter, (PathFilter)PathFilters.acceptAll(), (LocalLoader)localLoader, paths));
        specBuilder.setModuleClassLoaderFactory(new BundleReferenceClassLoader.Factory<SystemBundleState>(systemBundle));
        try {
            final ModuleSpec moduleSpec = specBuilder.create();
            ModuleLoader moduleLoader = new ModuleLoader(){

                protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                    return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                }

                public String toString() {
                    return ((Object)((Object)this)).getClass().getSimpleName();
                }
            };
            frameworkModule = moduleLoader.loadModule(specBuilder.getIdentifier());
        }
        catch (ModuleLoadException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateFrameworkModule(ex);
        }
        return frameworkModule;
    }
}

