/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.FrameworkBuilder;
import org.jboss.osgi.framework.spi.ServiceTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

final class FrameworkProxy
implements Framework {
    private final FrameworkBuilder frameworkBuilder;
    private BundleManagerPlugin bundleManager;
    private boolean firstInit;

    FrameworkProxy(FrameworkBuilder frameworkBuilder) {
        this.frameworkBuilder = frameworkBuilder;
        this.firstInit = true;
    }

    public long getBundleId() {
        return 0L;
    }

    public String getSymbolicName() {
        return "org.jboss.osgi.framework";
    }

    public String getLocation() {
        return "org.jboss.osgi.framework";
    }

    public Version getVersion() {
        return BundleManagerPlugin.getFrameworkVersion();
    }

    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (this.bundleManager != null) {
            SystemBundleState sysbundle = this.bundleManager.getSystemBundle();
            result = sysbundle != null ? sysbundle.adapt(type) : null;
        }
        return result;
    }

    public void init() throws BundleException {
        int state = this.getState();
        if (state == 8 || state == 32 || state == 16) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("Init framework", new Object[0]);
        try {
            ServiceTarget serviceTarget;
            ServiceContainer serviceContainer = this.frameworkBuilder.getServiceContainer();
            if (serviceContainer == null) {
                serviceContainer = this.frameworkBuilder.createServiceContainer();
            }
            if ((serviceTarget = this.frameworkBuilder.getServiceTarget()) == null) {
                serviceTarget = serviceContainer.subTarget();
            }
            this.bundleManager = (BundleManagerPlugin)this.frameworkBuilder.createFrameworkServices(serviceContainer, this.firstInit);
            this.bundleManager.setManagerState(8);
            ServiceTracker serviceTracker = new ServiceTracker("Framework.init");
            this.frameworkBuilder.installServices(FrameworkBuilder.FrameworkPhase.CREATE, serviceTarget, (ServiceListener<Object>)serviceTracker);
            this.frameworkBuilder.installServices(FrameworkBuilder.FrameworkPhase.INIT, serviceTarget, (ServiceListener<Object>)serviceTracker);
            if (!serviceTracker.awaitCompletion()) {
                throw serviceTracker.getFirstFailure();
            }
            this.bundleManager.setFramework(this);
        }
        catch (BundleException ex) {
            this.bundleManager.setManagerState(2);
            throw ex;
        }
        catch (Throwable ex) {
            this.bundleManager.setManagerState(2);
            throw FrameworkMessages.MESSAGES.cannotInitializeFramework(ex);
        }
        finally {
            this.firstInit = false;
        }
    }

    public void start() throws BundleException {
        this.start(0);
    }

    public void start(int options) throws BundleException {
        if (this.getState() != 8) {
            this.init();
        }
        FrameworkLogger.LOGGER.debugf("Start framework", new Object[0]);
        try {
            ServiceTracker serviceTracker = new ServiceTracker("Framework.start");
            this.frameworkBuilder.installServices(FrameworkBuilder.FrameworkPhase.ACTIVE, this.bundleManager.getServiceTarget(), (ServiceListener<Object>)serviceTracker);
            if (!serviceTracker.awaitCompletion()) {
                throw serviceTracker.getFirstFailure();
            }
            this.bundleManager.setManagerState(32);
        }
        catch (BundleException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw FrameworkMessages.MESSAGES.cannotStartFramework(ex);
        }
    }

    public void stop() throws BundleException {
        this.stop(0);
    }

    public void stop(int options) throws BundleException {
        if (this.bundleManager != null) {
            this.bundleManager.shutdownManager(false);
        }
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        return this.bundleManager != null ? this.bundleManager.waitForStop(timeout) : new FrameworkEvent(64, (Bundle)this, null);
    }

    public void update(InputStream input) throws BundleException {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.update();
    }

    public void update() {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("update framework", new Object[0]);
        final int targetState = this.getState();
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                try {
                    FrameworkProxy.this.bundleManager.shutdownManager(true);
                    if (targetState == 8) {
                        FrameworkProxy.this.init();
                    }
                    if (targetState == 32) {
                        FrameworkProxy.this.start();
                    }
                }
                catch (Exception ex) {
                    FrameworkLogger.LOGGER.errorCannotUpdateFramework(ex);
                }
            }
        };
        new Thread(cmd, "Framework update thread").run();
    }

    public void uninstall() throws BundleException {
        throw FrameworkMessages.MESSAGES.cannotUninstallSystemBundle();
    }

    public int getState() {
        return this.bundleManager != null ? this.bundleManager.getManagerState() : 2;
    }

    public Dictionary<String, String> getHeaders() {
        this.assertNotStopped();
        return this.getSystemBundle().getHeaders();
    }

    public ServiceReference<?>[] getRegisteredServices() {
        this.assertNotStopped();
        return this.getSystemBundle().getRegisteredServices();
    }

    public ServiceReference<?>[] getServicesInUse() {
        this.assertNotStopped();
        return this.getSystemBundle().getServicesInUse();
    }

    public boolean hasPermission(Object permission) {
        this.assertNotStopped();
        return this.getSystemBundle().hasPermission(permission);
    }

    public URL getResource(String name) {
        this.assertNotStopped();
        return this.getSystemBundle().getResource(name);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        this.assertNotStopped();
        return this.getSystemBundle().getHeaders(locale);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.assertNotStopped();
        return this.getSystemBundle().loadClass(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        this.assertNotStopped();
        return this.getSystemBundle().getResources(name);
    }

    public Enumeration<String> getEntryPaths(String path) {
        this.assertNotStopped();
        return this.getSystemBundle().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        this.assertNotStopped();
        return this.getSystemBundle().getEntry(path);
    }

    public long getLastModified() {
        this.assertNotStopped();
        return this.getSystemBundle().getLastModified();
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        this.assertNotStopped();
        return this.getSystemBundle().findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return !this.hasStopped() ? this.getSystemBundle().getBundleContext() : null;
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    private boolean hasStopped() {
        return this.bundleManager == null || this.bundleManager.hasStopped();
    }

    private void assertNotStopped() {
        if (this.hasStopped()) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkAlreadyStopped();
        }
    }

    private SystemBundleState getSystemBundle() {
        if (this.bundleManager == null) {
            throw FrameworkMessages.MESSAGES.illegalStateFrameworkNotInitialized();
        }
        return this.bundleManager.getFrameworkState().getSystemBundle();
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(Bundle o) {
        throw new UnsupportedOperationException();
    }
}

