/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.FrameworkWiringLock;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.LockUtils;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleWiringSupport;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractBundleWire;
import org.jboss.osgi.resolver.spi.ResolverHookException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.ResolutionException;

public final class FrameworkWiringImpl
implements FrameworkWiring {
    private final BundleManagerPlugin bundleManager;
    private final FrameworkEvents events;
    private final XEnvironment environment;
    private final XResolver resolver;
    private final LockManager lockManager;
    private final ExecutorService executorService;

    public FrameworkWiringImpl(BundleManager bundleManager, FrameworkEvents events, XEnvironment environment, XResolver resolver, LockManager lockManager, ExecutorService executorService) {
        this.bundleManager = (BundleManagerPlugin)bundleManager;
        this.events = events;
        this.environment = environment;
        this.resolver = resolver;
        this.lockManager = lockManager;
        this.executorService = executorService;
    }

    public Bundle getBundle() {
        return this.bundleManager.getSystemBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBundles(Collection<Bundle> bundles, final FrameworkListener ... listeners) {
        ArrayList<Bundle> bundlesToRefresh = new ArrayList<Bundle>();
        final ArrayList<XBundle> dependencyClosure = new ArrayList<XBundle>();
        LockManager.LockContext lockContext = null;
        try {
            lockContext = this.lockEnvironment(LockManager.Method.REFRESH, new XResource[0]);
            if (bundles == null) {
                bundlesToRefresh.addAll(this.getRemovalPendingBundles());
            } else {
                bundlesToRefresh.addAll(bundles);
            }
            for (Bundle auxBundle : this.getDependencyClosure(bundlesToRefresh)) {
                XBundle bundle2 = (XBundle)auxBundle;
                dependencyClosure.add(bundle2);
            }
            this.unlockEnvironment(lockContext);
        }
        catch (Throwable throwable) {
            this.unlockEnvironment(lockContext);
            throw throwable;
        }
        FrameworkLogger.LOGGER.debugf("Refresh bundles %s", bundlesToRefresh);
        FrameworkLogger.LOGGER.debugf("Dependency closure %s", dependencyClosure);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FrameworkWiringImpl.this.refreshBundlesInternal(dependencyClosure, listeners);
            }
        };
        if (!this.executorService.isShutdown()) {
            this.executorService.execute(runner);
        }
    }

    private void refreshBundlesInternal(List<XBundle> dependencyClosure, FrameworkListener ... listeners) {
        ArrayList<XBundle> stopList = new ArrayList<XBundle>();
        ArrayList<XBundle> uninstallBundles = new ArrayList<XBundle>();
        for (Bundle bundle2 : dependencyClosure) {
            XBundle bundle22 = (XBundle)bundle2;
            int state = bundle22.getState();
            if (state == 1) {
                uninstallBundles.add(bundle22);
                continue;
            }
            if (state != 32 && state != 8) continue;
            stopList.add(bundle22);
        }
        LockManager.LockContext context = null;
        try {
            FrameworkWiringLock frameworkWiringLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
            XBundle[] bundles = dependencyClosure.toArray(new XBundle[dependencyClosure.size()]);
            LockManager.LockableItem[] items = LockUtils.getLockableItems(bundles, new LockManager.LockableItem[]{frameworkWiringLock});
            context = this.lockManager.lockItems(LockManager.Method.REFRESH, items);
            BundleStartLevelComparator startLevelComparator = new BundleStartLevelComparator();
            Collections.sort(stopList, startLevelComparator);
            ListIterator it = stopList.listIterator(stopList.size());
            while (it.hasPrevious()) {
                XBundle bundle3 = (XBundle)it.previous();
                try {
                    this.bundleManager.stopBundleLifecycle(bundle3, 1);
                }
                catch (Exception th) {
                    this.events.fireFrameworkEvent(bundle3, 2, th, new FrameworkListener[0]);
                }
            }
            for (XBundle bundle3 : uninstallBundles) {
                if (bundle3 instanceof UserBundleState) {
                    this.bundleManager.uninstallBundle(bundle3, 0);
                } else {
                    XBundleRevision current = bundle3.getBundleRevision();
                    BundleRevisions brevs = (BundleRevisions)bundle3.adapt(BundleRevisions.class);
                    for (BundleRevision aux : brevs.getRevisions()) {
                        XBundleRevision brev = (XBundleRevision)aux;
                        if (brev == current) continue;
                        this.bundleManager.removeRevisionLifecycle(brev, 0);
                    }
                }
                dependencyClosure.remove(bundle3);
            }
            for (XBundle bundle3 : dependencyClosure) {
                if (!(bundle3 instanceof UserBundleState)) continue;
                try {
                    UserBundleState userBundle = (UserBundleState)bundle3;
                    userBundle.refresh();
                }
                catch (Exception th) {
                    this.events.fireFrameworkEvent(bundle3, 2, th, new FrameworkListener[0]);
                }
            }
            for (XBundle bundle3 : stopList) {
                try {
                    this.bundleManager.startBundleLifecycle(bundle3, 1);
                }
                catch (Exception th) {
                    this.events.fireFrameworkEvent(bundle3, 2, th, new FrameworkListener[0]);
                }
            }
            SystemBundleState systemBundle = this.bundleManager.getSystemBundle();
            this.events.fireFrameworkEvent(systemBundle, 4, null, listeners);
            this.lockManager.unlockItems(context);
        }
        catch (BundleException bundleException) {
            try {
                throw FrameworkMessages.MESSAGES.illegalStateCannotRefreshBundles(bundleException);
            }
            catch (Throwable throwable) {
                this.lockManager.unlockItems(context);
                throw throwable;
            }
        }
    }

    public boolean resolveBundles(Collection<Bundle> bundles) {
        if (bundles == null) {
            Set<XBundle> bundleset = this.bundleManager.getBundles(2);
            bundles = new ArrayList<XBundle>(bundleset);
        }
        FrameworkLogger.LOGGER.debugf("Resolve bundles %s", bundles);
        LinkedHashSet<XBundleRevision> resolvableRevisions = new LinkedHashSet<XBundleRevision>();
        for (Bundle aux : bundles) {
            XBundle bundleState = (XBundle)aux;
            resolvableRevisions.add(bundleState.getBundleRevision());
        }
        boolean result = true;
        try {
            XResolveContext context = this.resolver.createResolveContext(this.environment, null, resolvableRevisions);
            this.resolver.resolveAndApply(context);
            for (BundleRevision bundleRevision : resolvableRevisions) {
                if (bundleRevision.getWiring() != null) continue;
                FrameworkLogger.LOGGER.debugf("Cannot resolve: %s", bundleRevision);
                result = false;
            }
        }
        catch (ResolutionException ex) {
            FrameworkLogger.LOGGER.debugf(ex, "Cannot resolve: %s", resolvableRevisions);
            result = false;
        }
        catch (ResolverHookException ex) {
            FrameworkLogger.LOGGER.debugf(ex, "Cannot resolve: %s", resolvableRevisions);
            result = false;
        }
        return result;
    }

    public Collection<Bundle> getRemovalPendingBundles() {
        HashSet<XBundle> result = new HashSet<XBundle>();
        for (XBundle bundle2 : this.bundleManager.getBundles(null)) {
            if (bundle2.getBundleId() == 0L) continue;
            BundleRevisions revisions = (BundleRevisions)bundle2.adapt(BundleRevisions.class);
            for (BundleRevision rev : revisions.getRevisions()) {
                BundleWiring bwiring;
                XBundleRevision brev = (XBundleRevision)rev;
                XBundleWiringSupport wiringSupport = brev.getWiringSupport();
                if (wiringSupport.isEffective() || (bwiring = (BundleWiring)wiringSupport.getWiring(false)) == null || !bwiring.isInUse()) continue;
                result.add(bundle2);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<Bundle> getDependencyClosure(Collection<Bundle> bundles) {
        if (bundles == null) {
            throw FrameworkMessages.MESSAGES.illegalArgumentNull("bundles");
        }
        HashSet<Bundle> closure = new HashSet<Bundle>();
        for (Bundle bundle2 : bundles) {
            this.transitiveDependencyClosure((XBundle)bundle2, closure);
        }
        return Collections.unmodifiableCollection(closure);
    }

    private void transitiveDependencyClosure(XBundle bundle2, Set<Bundle> closure) {
        if (bundle2.getBundleId() != 0L && !closure.contains(bundle2)) {
            closure.add((Bundle)bundle2);
            BundleRevisions brevs = (BundleRevisions)bundle2.adapt(BundleRevisions.class);
            for (BundleRevision aux : brevs.getRevisions()) {
                XBundleRevision brev = (XBundleRevision)aux;
                BundleWiring wiring = brev.getWiringSupport().getWiring(false);
                if (wiring == null) continue;
                this.transitiveDependencyClosure(brev, (Wiring)wiring, closure);
            }
        }
    }

    private void transitiveDependencyClosure(XBundleRevision brev, Wiring wiring, Set<Bundle> closure) {
        if (brev instanceof FragmentBundleRevision) {
            for (Wire wire : wiring.getRequiredResourceWires("osgi.wiring.host")) {
                AbstractBundleWire bwire = (AbstractBundleWire)wire;
                Bundle provider = bwire.getProviderWiring(false).getBundle();
                this.transitiveDependencyClosure((XBundle)provider, closure);
            }
        } else {
            for (Wire wire : wiring.getProvidedResourceWires(null)) {
                XBundleRevision requirer = (XBundleRevision)wire.getRequirer();
                this.transitiveDependencyClosure(requirer.getBundle(), closure);
            }
        }
    }

    private LockManager.LockContext lockEnvironment(LockManager.Method method, XResource ... resources) {
        FrameworkWiringLock wireLock = this.lockManager.getItemForType(FrameworkWiringLock.class);
        return this.lockManager.lockItems(method, this.getLockableItems(wireLock, resources));
    }

    private LockManager.LockableItem[] getLockableItems(LockManager.LockableItem item, XResource ... resources) {
        ArrayList<LockManager.LockableItem> items = new ArrayList<LockManager.LockableItem>();
        items.add(item);
        if (resources != null) {
            for (XResource res : resources) {
                XBundleRevision brev = (XBundleRevision)res;
                if (!(brev.getBundle() instanceof LockManager.LockableItem)) continue;
                items.add((LockManager.LockableItem)brev.getBundle());
            }
        }
        return items.toArray(new LockManager.LockableItem[items.size()]);
    }

    private void unlockEnvironment(LockManager.LockContext context) {
        this.lockManager.unlockItems(context);
    }

    private static class BundleStartLevelComparator
    implements Comparator<Bundle> {
        private BundleStartLevelComparator() {
        }

        @Override
        public int compare(Bundle o1, Bundle o2) {
            int sl2;
            int sl1 = ((BundleStartLevel)o1.adapt(BundleStartLevel.class)).getStartLevel();
            return sl1 - (sl2 = ((BundleStartLevel)o2.adapt(BundleStartLevel.class)).getStartLevel()) != 0 ? sl1 - sl2 : (int)(o1.getBundleId() - o2.getBundleId());
        }
    }
}

