/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.spi.URLResource;
import org.jboss.osgi.framework.spi.VirtualFileResourceLoader;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWiring;

final class RevisionContentResourceLoader
implements IterableResourceLoader {
    private final HostBundleRevision hostRev;
    private final RevisionContent revContent;
    private final IterableResourceLoader delegate;

    RevisionContentResourceLoader(HostBundleRevision hostRev, RevisionContent revContent) {
        assert (hostRev != null) : "Null hostRev";
        assert (revContent != null) : "Null revContent";
        this.delegate = new VirtualFileResourceLoader(revContent.getVirtualFile());
        this.revContent = revContent;
        this.hostRev = hostRev;
    }

    public String getRootName() {
        return this.delegate.getRootName();
    }

    public ClassSpec getClassSpec(String fileName) throws IOException {
        return this.delegate.getClassSpec(fileName);
    }

    public PackageSpec getPackageSpec(String name) throws IOException {
        return this.delegate.getPackageSpec(name);
    }

    public Resource getResource(String path) {
        URL url = this.revContent.getEntry(path);
        return url != null ? new URLResource(url) : null;
    }

    public String getLibrary(String name) {
        return null;
    }

    public Collection<String> getPaths() {
        return this.delegate.getPaths();
    }

    public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
        List preqs;
        ArrayList<String> importedPaths = new ArrayList<String>();
        BundleWiring wiring = (BundleWiring)this.hostRev.getBundle().adapt(BundleWiring.class);
        List list = preqs = wiring != null ? wiring.getRequirements("osgi.wiring.package") : null;
        if (preqs != null) {
            for (BundleRequirement req : preqs) {
                XPackageRequirement preq = (XPackageRequirement)req;
                String packageName = preq.getPackageName();
                importedPaths.add(packageName.replace('.', '/'));
            }
        }
        Iterator itres = this.delegate.iterateResources(startPath, recursive);
        if (importedPaths.isEmpty()) {
            return itres;
        }
        ArrayList<Resource> filteredResources = new ArrayList<Resource>();
        while (itres.hasNext()) {
            Resource res = (Resource)itres.next();
            String pathname = res.getName();
            int lastIndex = pathname.lastIndexOf(47);
            String respath = lastIndex > 0 ? pathname.substring(0, lastIndex) : pathname;
            if (importedPaths.contains(respath)) continue;
            filteredResources.add(res);
        }
        return filteredResources.iterator();
    }

    public String toString() {
        return this.revContent.toString();
    }
}

