/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BootstrapBundlesResolve;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BootstrapBundlesInstall<T>
extends BootstrapBundlesService<T> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();

    public BootstrapBundlesInstall(ServiceName baseName) {
        super(baseName, IntegrationServices.BootstrapPhase.INSTALL);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedBundleContext);
        builder.addDependency(IntegrationServices.FRAMEWORK_CORE_SERVICES);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    protected BundleManager getBundleManager() {
        return (BundleManager)this.injectedBundleManager.getValue();
    }

    protected BundleContext getBundleContext() {
        return (BundleContext)this.injectedBundleContext.getValue();
    }

    protected void installBootstrapBundles(ServiceTarget serviceTarget, List<Deployment> deployments) {
        HashSet<XBundleRevision> installedRevisions = new HashSet<XBundleRevision>();
        for (Deployment dep : deployments) {
            try {
                XBundleRevision brev = this.getBundleManager().createBundleRevision(this.getBundleContext(), dep, serviceTarget);
                installedRevisions.add(brev);
            }
            catch (BundleException ex) {
                FrameworkLogger.LOGGER.errorStateCannotInstallInitialBundle(ex, dep.getLocation());
            }
        }
        this.installResolveService(serviceTarget, installedRevisions);
    }

    protected ServiceController<T> installResolveService(ServiceTarget serviceTarget, Set<XBundleRevision> installedRevisions) {
        return new BootstrapBundlesResolve(this.getServiceName().getParent(), installedRevisions).install(serviceTarget, this.getServiceListener());
    }
}

