/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleLifecycleImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolver;

public class BundleLifecyclePlugin
extends AbstractIntegrationService<BundleLifecycle> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();

    public BundleLifecyclePlugin() {
        super(IntegrationServices.BUNDLE_LIFECYCLE_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<BundleLifecycle> builder) {
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependency(Services.FRAMEWORK_CREATE);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected BundleLifecycle createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        XEnvironment environment = (XEnvironment)this.injectedEnvironment.getValue();
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        return new BundleLifecycleImpl(bundleManager);
    }
}

