/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkModuleProviderImpl;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.SystemPaths;

public class FrameworkModuleProviderPlugin
extends AbstractIntegrationService<FrameworkModuleProvider> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<SystemPaths> injectedSystemPaths = new InjectedValue();

    public FrameworkModuleProviderPlugin() {
        super(IntegrationServices.FRAMEWORK_MODULE_PLUGIN);
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkModuleProvider> builder) {
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PLUGIN, SystemPaths.class, this.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkModuleProvider createServiceValue(StartContext startContext) {
        SystemPaths systemPaths = (SystemPaths)this.injectedSystemPaths.getValue();
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        return new FrameworkModuleProviderImpl(bundleManager, systemPaths);
    }
}

