/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ToOneEntityLoader {
    public static Object loadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, AuditConfiguration verCfg) {
        if (verCfg.getEntCfg().getNotVersionEntityConfiguration(entityName) == null) {
            return versionsReader.find(entityClass, entityName, entityId, revision);
        }
        return versionsReader.getSessionImplementor().immediateLoad(entityName, (Serializable)entityId);
    }

    public static Object createProxy(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, AuditConfiguration verCfg) {
        EntityPersister persister = versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName);
        return persister.createProxy((Serializable)entityId, (SessionImplementor)new ToOneDelegateSessionImplementor(versionsReader, entityClass, entityId, revision, verCfg));
    }

    public static Object createProxyOrLoadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, AuditConfiguration verCfg) {
        EntityPersister persister = versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName);
        if (persister.hasProxy()) {
            return ToOneEntityLoader.createProxy(versionsReader, entityClass, entityName, entityId, revision, verCfg);
        }
        return ToOneEntityLoader.loadImmediate(versionsReader, entityClass, entityName, entityId, revision, verCfg);
    }
}

