/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.wsdl11.SchemaUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ValidatorUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidatorUtil.class);

    private ValidatorUtil() {
    }

    public static SchemaCollection getSchema(Definition def) {
        ServiceInfo serviceInfo = new ServiceInfo();
        new SchemaUtil(BusFactory.getThreadDefaultBus(), new HashMap()).getSchemas(def, serviceInfo);
        return serviceInfo.getXmlSchemaCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SchemaCollection> getSchemaList(Document document, String baseURI) throws IOException, SAXException {
        ArrayList<SchemaCollection> schemaList = new ArrayList<SchemaCollection>();
        if (document == null) {
            return schemaList;
        }
        Document document2 = document;
        synchronized (document2) {
            baseURI = URLEncoder.encode(baseURI, "utf-8");
            SchemaCollection schemaCol = new SchemaCollection();
            schemaCol.setBaseUri(baseURI);
            List elemList = DOMUtils.findAllElementsByTagNameNS((Element)document.getDocumentElement(), (String)"http://www.w3.org/2001/XMLSchema", (String)"schema");
            for (Element schemaEl : elemList) {
                String tns = schemaEl.getAttribute("targetNamespace");
                try {
                    schemaCol.read(schemaEl, tns);
                }
                catch (RuntimeException ex) {
                    LOG.log(Level.WARNING, "SCHEMA_READ_FAIL", tns);
                    try {
                        schemaCol.read(schemaEl, baseURI);
                    }
                    catch (RuntimeException ex2) {
                        LOG.log(Level.WARNING, "SCHEMA_READ_FAIL", baseURI);
                    }
                }
            }
            schemaList.add(schemaCol);
            Map<String, Document> wsdlImports = ValidatorUtil.getImportedWsdlMap(document, baseURI);
            for (Document wsdlImport : wsdlImports.values()) {
                schemaList.addAll(ValidatorUtil.getSchemaList(wsdlImport, baseURI));
            }
        }
        return schemaList;
    }

    public static Map<String, Document> getImportedWsdlMap(Document document, String basePath) throws IOException, SAXException {
        HashMap<String, Document> docMap = new HashMap<String, Document>();
        if (document == null) {
            return docMap;
        }
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ToolException((Throwable)e);
        }
        String myBasePath = basePath;
        try {
            myBasePath = new URI(basePath.replaceAll(" ", "%20")).getPath();
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)document.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"import");
        for (Element elem : elemList) {
            String systemId;
            NamedNodeMap attributes = elem.getAttributes();
            String namespace = attributes.getNamedItem("namespace").getNodeValue();
            if (docMap.containsKey(namespace)) continue;
            try {
                systemId = ValidatorUtil.getImportedUrl(attributes.getNamedItem("location").getNodeValue(), myBasePath);
            }
            catch (IOException ioe) {
                throw new ToolException((Throwable)ioe);
            }
            if (namespace == null || systemId == null) continue;
            Document docImport = docBuilder.parse(systemId);
            Node node = DOMUtils.getChild((Node)docImport, null);
            if (node != null && !"definitions".equals(node.getLocalName())) {
                Message msg = new Message("NOT_A_WSDLFILE", LOG, new Object[]{systemId});
                throw new ToolException(msg);
            }
            docMap.putAll(ValidatorUtil.getImportedWsdlMap(docImport, myBasePath));
            docMap.put(namespace, docImport);
        }
        return docMap;
    }

    private static String getImportedUrl(String theImportPath, String baseURI) throws IOException {
        File file = new File(theImportPath);
        if (file != null && file.exists()) {
            return file.toURI().toURL().toString();
        }
        File baseFile = new File(baseURI);
        file = new File(baseFile.getParent(), theImportPath);
        if (file != null && file.exists()) {
            return file.toURI().toURL().toString();
        }
        return null;
    }
}

