/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.naming.ConstructorManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ReflectiveClassIntrospector
implements EEClassIntrospector,
Service<EEClassIntrospector> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ee", "reflectiveClassIntrospector"});
    public static final RuntimePermission CHECK_MEMBER_ACCESS_PERMISSION = new RuntimePermission("accessDeclaredMembers");

    public ReflectiveClassIntrospector() {
        if (WildFlySecurityManager.isChecking()) {
            SecurityManager s = System.getSecurityManager();
            s.checkPermission(CHECK_MEMBER_ACCESS_PERMISSION);
        }
    }

    @Override
    public ManagedReferenceFactory createFactory(final Class<?> clazz) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<ManagedReferenceFactory>(){

                @Override
                public ManagedReferenceFactory run() {
                    try {
                        return new ConstructorManagedReferenceFactory(clazz.getDeclaredConstructor(new Class[0]));
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        try {
            return new ConstructorManagedReferenceFactory(clazz.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ManagedReference createInstance(Object instance) {
        return null;
    }

    public void start(StartContext startContext) throws StartException {
    }

    public void stop(StopContext stopContext) {
    }

    public EEClassIntrospector getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

