/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderServiceNameProvider;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.stateful.MarshallingConfigurationRepositoryServiceConfigurator;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ChildTargetService;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceSupplierDependency;

public class CacheDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext context) {
        final DeploymentUnit unit = context.getDeploymentUnit();
        ServiceName name = unit.getServiceName();
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        final CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceTarget target = context.getServiceTarget();
        final HashSet<ServiceSupplierDependency> dependencies = new HashSet<ServiceSupplierDependency>();
        for (ComponentDescription description : moduleDescription.getComponentDescriptions()) {
            if (!(description instanceof StatefulComponentDescription)) continue;
            StatefulComponentDescription statefulDescription = (StatefulComponentDescription)description;
            dependencies.add(new ServiceSupplierDependency(CacheDependenciesProcessor.getCacheFactoryBuilderServiceName(statefulDescription)));
        }
        ChildTargetService service = new ChildTargetService((Consumer)new Consumer<ServiceTarget>(){

            @Override
            public void accept(ServiceTarget target) {
                HashSet builders = new HashSet(dependencies.size());
                for (Supplier dependency : dependencies) {
                    builders.add(dependency.get());
                }
                for (CacheFactoryBuilder builder : builders) {
                    for (CapabilityServiceConfigurator configurator : builder.getDeploymentServiceConfigurators(unit)) {
                        configurator.configure(support).build(target).install();
                    }
                }
            }
        });
        ServiceBuilder builder = target.addService(name.append(new String[]{"cache-dependencies-installer"}));
        for (Dependency dependency : dependencies) {
            dependency.register(builder);
        }
        builder.setInstance((Service)service).install();
        new MarshallingConfigurationRepositoryServiceConfigurator(unit).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    private static ServiceName getCacheFactoryBuilderServiceName(StatefulComponentDescription description) {
        if (!description.isPassivationApplicable()) {
            return CacheFactoryBuilderServiceNameProvider.DEFAULT_PASSIVATION_DISABLED_CACHE_SERVICE_NAME;
        }
        CacheInfo cache = description.getCache();
        return cache != null ? new CacheFactoryBuilderServiceNameProvider(cache.getName()).getServiceName() : CacheFactoryBuilderServiceNameProvider.DEFAULT_CACHE_SERVICE_NAME;
    }
}

