/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;

public class EJBBusinessMethod
implements Serializable {
    private final String methodName;
    private final Class<?>[] methodParamTypes;
    private final MethodInterfaceType viewType;
    private final int hashCode;

    public EJBBusinessMethod(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public EJBBusinessMethod(String methodName, Class<?> ... methodParamTypes) {
        this(MethodInterfaceType.Bean, methodName, methodParamTypes);
    }

    public EJBBusinessMethod(MethodInterfaceType view, String methodName, Class<?> ... paramTypes) {
        if (methodName == null) {
            throw EjbLogger.ROOT_LOGGER.methodNameIsNull();
        }
        this.methodName = methodName;
        this.methodParamTypes = paramTypes == null ? new Class[]{} : paramTypes;
        this.viewType = view == null ? MethodInterfaceType.Bean : view;
        this.hashCode = this.generateHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EJBBusinessMethod that = (EJBBusinessMethod)o;
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (!Arrays.equals(this.methodParamTypes, that.methodParamTypes)) {
            return false;
        }
        return this.viewType == that.viewType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.methodName.hashCode();
        result = 31 * result + Arrays.hashCode(this.methodParamTypes);
        result = 31 * result + this.viewType.hashCode();
        return result;
    }
}

