/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.subsystem.EJB3Extension;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;

public class IdentityResourceDefinition
extends SimpleResourceDefinition {
    private static final String SECURITY_DOMAIN_CAPABILITY_NAME = "org.wildfly.security.security-domain";
    public static final String IDENTITY_CAPABILITY_NAME = "org.wildfly.ejb3.identity";
    static final RuntimeCapability<Void> IDENTITY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ejb3.identity", Function.class).build();
    public static final StringListAttributeDefinition OUTFLOW_SECURITY_DOMAINS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("outflow-security-domains").setRequired(false)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setCapabilityReference("org.wildfly.security.security-domain", "org.wildfly.ejb3.identity", false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).build();
    static final IdentityResourceDefinition INSTANCE = new IdentityResourceDefinition();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{OUTFLOW_SECURITY_DOMAINS};
    private static List<String> outflowSecurityDomains = Collections.synchronizedList(new ArrayList());

    private IdentityResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(EJB3SubsystemModel.IDENTITY_PATH, EJB3Extension.getResourceDescriptionResolver("identity")).setAddHandler((OperationStepHandler)new AddHandler()).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler(new RuntimeCapability[]{IDENTITY_CAPABILITY})).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{IDENTITY_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        outflowSecurityDomains.clear();
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)handler);
        }
    }

    BooleanSupplier getOutflowSecurityDomainsConfiguredSupplier() {
        return () -> !outflowSecurityDomains.isEmpty();
    }

    static class IdentityService
    implements org.jboss.msc.service.Service<Function<SecurityIdentity, Set<SecurityIdentity>>> {
        private final List<InjectedValue<SecurityDomain>> outflowSecurityDomainInjectors = new ArrayList<InjectedValue<SecurityDomain>>();
        private Set<SecurityDomain> outflowSecurityDomains = new HashSet<SecurityDomain>();

        IdentityService() {
        }

        public void start(StartContext context) throws StartException {
            HashSet<SecurityDomain> securityDomains = new HashSet<SecurityDomain>();
            for (InjectedValue<SecurityDomain> outflowSecurityDomainInjector : this.outflowSecurityDomainInjectors) {
                SecurityDomain value = (SecurityDomain)outflowSecurityDomainInjector.getValue();
                securityDomains.add(value);
            }
            this.outflowSecurityDomains.addAll(securityDomains);
        }

        private Set<SecurityIdentity> outflowIdentity(SecurityIdentity securityIdentity) {
            HashSet<SecurityIdentity> outflowedIdentities = new HashSet<SecurityIdentity>(this.outflowSecurityDomains.size());
            if (securityIdentity != null) {
                for (SecurityDomain outflowSecurityDomain : this.outflowSecurityDomains) {
                    try {
                        ServerAuthenticationContext serverAuthenticationContext = outflowSecurityDomain.createNewAuthenticationContext();
                        if (!serverAuthenticationContext.importIdentity(securityIdentity)) continue;
                        outflowedIdentities.add(serverAuthenticationContext.getAuthorizedIdentity());
                    }
                    catch (IllegalStateException | RealmUnavailableException throwable) {}
                }
            }
            return outflowedIdentities;
        }

        public void stop(StopContext context) {
            this.outflowSecurityDomains = null;
        }

        public Function<SecurityIdentity, Set<SecurityIdentity>> getValue() throws IllegalStateException, IllegalArgumentException {
            return this::outflowIdentity;
        }

        Injector<SecurityDomain> createOutflowSecurityDomainInjector() {
            InjectedValue injectedValue = new InjectedValue();
            this.outflowSecurityDomainInjectors.add((InjectedValue<SecurityDomain>)injectedValue);
            return injectedValue;
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private AddHandler() {
            super(IDENTITY_CAPABILITY, new AttributeDefinition[]{OUTFLOW_SECURITY_DOMAINS});
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            outflowSecurityDomains = OUTFLOW_SECURITY_DOMAINS.unwrap((ExpressionResolver)context, resource.getModel());
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            IdentityService identityService = new IdentityService();
            CapabilityServiceBuilder capabilityServiceBuilder = context.getCapabilityServiceTarget().addCapability(IDENTITY_CAPABILITY);
            for (String outflowSecurityDomain : outflowSecurityDomains) {
                capabilityServiceBuilder.addCapabilityRequirement(IdentityResourceDefinition.SECURITY_DOMAIN_CAPABILITY_NAME, SecurityDomain.class, identityService.createOutflowSecurityDomainInjector(), new String[]{outflowSecurityDomain});
            }
            capabilityServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).setInstance((Service)identityService).install();
        }
    }
}

