/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.remote.LocalTransportProvider;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

class EJBRemoteInvocationPassByValueWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJBRemoteInvocationPassByValueWriteHandler INSTANCE = new EJBRemoteInvocationPassByValueWriteHandler((AttributeDefinition)EJB3SubsystemRootResourceDefinition.PASS_BY_VALUE);
    private final AttributeDefinition attributeDefinition;

    private EJBRemoteInvocationPassByValueWriteHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateDefaultLocalEJBReceiverService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateDefaultLocalEJBReceiverService(context, restored);
    }

    void updateDefaultLocalEJBReceiverService(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean passByValue;
        ModelNode passByValueModel = this.attributeDefinition.resolveModelAttribute(context, model);
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceName localTransportProviderServiceName = passByValueModel.isDefined() ? ((passByValue = passByValueModel.asBoolean(true)) ? LocalTransportProvider.BY_VALUE_SERVICE_NAME : LocalTransportProvider.BY_REFERENCE_SERVICE_NAME) : LocalTransportProvider.BY_VALUE_SERVICE_NAME;
        ServiceController existingDefaultLocalEJBReceiverServiceController = registry.getService(LocalTransportProvider.DEFAULT_LOCAL_TRANSPORT_PROVIDER_SERVICE_NAME);
        if (existingDefaultLocalEJBReceiverServiceController != null) {
            context.removeService(existingDefaultLocalEJBReceiverServiceController);
        }
        ServiceName sn = LocalTransportProvider.DEFAULT_LOCAL_TRANSPORT_PROVIDER_SERVICE_NAME;
        ServiceBuilder sb = context.getServiceTarget().addService(sn);
        Consumer transportConsumer = sb.provides(new ServiceName[]{sn});
        Supplier transportSupplier = sb.requires(localTransportProviderServiceName);
        sb.setInstance((Service)new DefaultLocalTransportProviderService(transportConsumer, transportSupplier));
        sb.install();
    }

    private static final class DefaultLocalTransportProviderService
    implements Service {
        private final Consumer<LocalTransportProvider> transportConsumer;
        private final Supplier<LocalTransportProvider> transportSupplier;

        private DefaultLocalTransportProviderService(Consumer<LocalTransportProvider> transportConsumer, Supplier<LocalTransportProvider> transportSupplier) {
            this.transportConsumer = transportConsumer;
            this.transportSupplier = transportSupplier;
        }

        public void start(StartContext startContext) {
            this.transportConsumer.accept(this.transportSupplier.get());
        }

        public void stop(StopContext stopContext) {
            this.transportConsumer.accept(null);
        }
    }
}

