/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.wildfly.httpclient.ejb.EjbHttpClientMessages;
import org.wildfly.httpclient.ejb.HttpEJBReceiver;

public class HttpClientProvider
implements EJBTransportProvider {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final Set<String> PROTOCOLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http", "https")));
    private static final AttachmentKey<HttpEJBReceiver> RECEIVER = new AttachmentKey();

    public void notifyRegistered(EJBReceiverContext receiverContext) {
        receiverContext.getClientContext().putAttachment(RECEIVER, (Object)new HttpEJBReceiver());
    }

    public boolean supportsProtocol(String uriScheme) {
        return PROTOCOLS.contains(uriScheme);
    }

    public EJBReceiver getReceiver(EJBReceiverContext ejbReceiverContext, String s) throws IllegalArgumentException {
        HttpEJBReceiver receiver;
        if (PROTOCOLS.contains(s) && (receiver = (HttpEJBReceiver)((Object)ejbReceiverContext.getClientContext().getAttachment(RECEIVER))) != null) {
            return receiver;
        }
        throw EjbHttpClientMessages.MESSAGES.couldNotCreateHttpEjbReceiverFor(s);
    }

    public void close(EJBReceiverContext receiverContext) throws Exception {
    }
}

