/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.AuditLoggerInfo;
import org.jboss.as.jmx.ExposeModelResource;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class JMXSubsystemAdd
extends AbstractAddStepHandler {
    private final AuditLoggerInfo auditLoggerInfo;

    JMXSubsystemAdd(AuditLoggerInfo auditLoggerInfo) {
        this.auditLoggerInfo = auditLoggerInfo;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.setEmptyObject();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            JMXSubsystemAdd.this.auditLoggerInfo.setBooting(false);
                        }
                    });
                }
            }, OperationContext.Stage.MODEL);
        } else {
            this.auditLoggerInfo.setBooting(false);
        }
        super.execute(context, operation);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        JMXSubsystemAdd.launchServices(context, model, verificationHandler, this.auditLoggerInfo, newControllers);
    }

    static void launchServices(OperationContext context, ModelNode model, ServiceVerificationHandler verificationHandler, AuditLoggerInfo auditLoggerInfo, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceController<?> controller;
        ModelNode recursiveModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        String resolvedDomain = JMXSubsystemAdd.getDomainName(context, recursiveModel, "resolved");
        String expressionsDomain = JMXSubsystemAdd.getDomainName(context, recursiveModel, "expression");
        boolean legacyWithProperPropertyFormat = false;
        if (model.hasDefined("proper-property-format")) {
            legacyWithProperPropertyFormat = ExposeModelResourceExpression.DOMAIN_NAME.resolveModelAttribute(context, recursiveModel).asBoolean();
        }
        ServiceController<?> serviceController = controller = verificationHandler != null ? MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, auditLoggerInfo, new ServiceListener[]{verificationHandler}) : MBeanServerService.addService(context.getServiceTarget(), resolvedDomain, expressionsDomain, legacyWithProperPropertyFormat, auditLoggerInfo, new ServiceListener[0]);
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    private static String getDomainName(OperationContext context, ModelNode model, String child) throws OperationFailedException {
        if (!model.hasDefined("expose-model")) {
            return null;
        }
        if (!model.get("expose-model").hasDefined(child)) {
            return null;
        }
        ModelNode childModel = model.get(new String[]{"expose-model", child});
        return ExposeModelResource.getDomainNameAttribute(child).resolveModelAttribute(context, childModel).asString();
    }
}

