/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jmx.JmxMessages;
import org.jboss.as.jmx.model.ChildAddOperationFinder;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.MBeanInfoFactory;
import org.jboss.as.jmx.model.NameConverter;
import org.jboss.as.jmx.model.ObjectNameAddressUtil;
import org.jboss.as.jmx.model.RootResourceIterator;
import org.jboss.as.jmx.model.TypeConverters;
import org.jboss.as.server.operations.RootResourceHack;
import org.jboss.dmr.ModelNode;

public class ModelControllerMBeanHelper {
    static final String CLASS_NAME = ModelController.class.getName();
    private final boolean standalone;
    private final ModelController controller;
    private final PathAddress CORE_SERVICE_PLATFORM_MBEAN = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"platform-mbean")});
    private final TypeConverters converters;
    private final ConfiguredDomains configuredDomains;
    private final String domain;

    ModelControllerMBeanHelper(TypeConverters converters, ConfiguredDomains configuredDomains, String domain, ModelController controller) {
        this.converters = converters;
        this.configuredDomains = configuredDomains;
        this.domain = domain;
        this.controller = controller;
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").setEmptyList();
        op.get("name").set("launch-type");
        ModelNode result = this.execute(op);
        String error = this.getFailureDescription(result);
        if (error != null) {
            throw new IllegalStateException(error);
        }
        this.standalone = result.require("result").asString().equals("STANDALONE");
    }

    int getMBeanCount() {
        return new RootResourceIterator<Integer>(this.getRootResourceAndRegistration().getResource(), new RootResourceIterator.ResourceAction<Integer>(){
            int count;

            @Override
            public boolean onResource(PathAddress address) {
                if (ModelControllerMBeanHelper.this.isExcludeAddress(address)) {
                    return false;
                }
                ++this.count;
                return true;
            }

            @Override
            public Integer getResult() {
                return this.count;
            }
        }).iterate();
    }

    Set<ObjectInstance> queryMBeans(final ObjectName name, QueryExp query) {
        return new RootResourceIterator<Set<ObjectInstance>>(this.getRootResourceAndRegistration().getResource(), new RootResourceIterator.ResourceAction<Set<ObjectInstance>>(){
            Set<ObjectInstance> set = new HashSet<ObjectInstance>();

            @Override
            public boolean onResource(PathAddress address) {
                if (ModelControllerMBeanHelper.this.isExcludeAddress(address)) {
                    return false;
                }
                ObjectName resourceName = ObjectNameAddressUtil.createObjectName(ModelControllerMBeanHelper.this.domain, address);
                if (name == null || name.apply(resourceName)) {
                    this.set.add(new ObjectInstance(resourceName, CLASS_NAME));
                }
                return true;
            }

            @Override
            public Set<ObjectInstance> getResult() {
                if (this.set.size() == 1 && this.set.contains(ModelControllerMBeanHelper.createRootObjectName(ModelControllerMBeanHelper.this.domain))) {
                    return Collections.emptySet();
                }
                return this.set;
            }
        }).iterate();
    }

    Set<ObjectName> queryNames(final ObjectName name, QueryExp query) {
        return new RootResourceIterator<Set<ObjectName>>(this.getRootResourceAndRegistration().getResource(), new RootResourceIterator.ResourceAction<Set<ObjectName>>(){
            Set<ObjectName> set = new HashSet<ObjectName>();

            @Override
            public boolean onResource(PathAddress address) {
                if (ModelControllerMBeanHelper.this.isExcludeAddress(address)) {
                    return false;
                }
                ObjectName resourceName = ObjectNameAddressUtil.createObjectName(ModelControllerMBeanHelper.this.domain, address);
                if (name == null || name.apply(resourceName)) {
                    this.set.add(resourceName);
                }
                return true;
            }

            @Override
            public Set<ObjectName> getResult() {
                if (this.set.size() == 1 && this.set.contains(ModelControllerMBeanHelper.createRootObjectName(ModelControllerMBeanHelper.this.domain))) {
                    return Collections.emptySet();
                }
                return this.set;
            }
        }).iterate();
    }

    PathAddress resolvePathAddress(ObjectName name) {
        return ObjectNameAddressUtil.resolvePathAddress(this.domain, this.getRootResourceAndRegistration().getResource(), name);
    }

    MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException {
        RootResourceHack.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = ObjectNameAddressUtil.resolvePathAddress(this.domain, reg.getResource(), name);
        if (address == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        return MBeanInfoFactory.createMBeanInfo(name, this.converters, this.configuredDomains, this.standalone, address, this.getMBeanRegistration(address, reg));
    }

    Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        RootResourceHack.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = ObjectNameAddressUtil.resolvePathAddress(this.domain, reg.getResource(), name);
        if (address == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        return this.getAttribute(reg, address, name, attribute);
    }

    AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        RootResourceHack.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = ObjectNameAddressUtil.resolvePathAddress(this.domain, reg.getResource(), name);
        if (address == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(reg, address, name, attribute)));
            }
            catch (AttributeNotFoundException e) {
                throw new ReflectionException(e);
            }
        }
        return list;
    }

    private Object getAttribute(RootResourceHack.ResourceAndRegistration reg, PathAddress address, ObjectName name, String attribute) throws ReflectionException, AttributeNotFoundException, InstanceNotFoundException {
        ImmutableManagementResourceRegistration registration = this.getMBeanRegistration(address, reg);
        DescriptionProvider provider = registration.getModelDescription(PathAddress.EMPTY_ADDRESS);
        if (provider == null) {
            throw JmxMessages.MESSAGES.descriptionProviderNotFound(address);
        }
        ModelNode description = provider.getModelDescription(null);
        String attributeName = this.findAttributeName(description.get("attributes"), attribute);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        ModelNode result = this.execute(op);
        String error = this.getFailureDescription(result);
        if (error != null) {
            throw new AttributeNotFoundException(error);
        }
        return this.converters.fromModelNode(description.require("attributes").require(attributeName), result.get("result"));
    }

    void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException {
        RootResourceHack.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = ObjectNameAddressUtil.resolvePathAddress(this.domain, reg.getResource(), name);
        if (address == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        this.setAttribute(reg, address, name, attribute);
    }

    AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        RootResourceHack.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = ObjectNameAddressUtil.resolvePathAddress(this.domain, reg.getResource(), name);
        if (address == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(reg, address, name, attribute);
            }
            catch (Exception e) {
                throw JmxMessages.MESSAGES.cannotSetAttribute(e, attribute.getName());
            }
        }
        return attributes;
    }

    private void setAttribute(RootResourceHack.ResourceAndRegistration reg, PathAddress address, ObjectName name, Attribute attribute) throws InvalidAttributeValueException, AttributeNotFoundException, InstanceNotFoundException {
        ImmutableManagementResourceRegistration registration = this.getMBeanRegistration(address, reg);
        DescriptionProvider provider = registration.getModelDescription(PathAddress.EMPTY_ADDRESS);
        if (provider == null) {
            throw JmxMessages.MESSAGES.descriptionProviderNotFound(address);
        }
        ModelNode description = provider.getModelDescription(null);
        String attributeName = this.findAttributeName(description.get("attributes"), attribute.getName());
        if (!this.standalone) {
            throw JmxMessages.MESSAGES.attributeNotWritable(attribute);
        }
        ModelNode op = new ModelNode();
        op.get("operation").set("write-attribute");
        op.get("address").set(address.toModelNode());
        op.get("name").set(attributeName);
        try {
            op.get("value").set(this.converters.toModelNode(description.require("attributes").require(attributeName), attribute.getValue()));
        }
        catch (ClassCastException e) {
            throw JmxMessages.MESSAGES.invalidAttributeType(e, attribute.getName());
        }
        ModelNode result = this.execute(op);
        String error = this.getFailureDescription(result);
        if (error != null) {
            throw new InvalidAttributeValueException(error);
        }
    }

    ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (this.resolvePathAddress(name) == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        return new ObjectInstance(name, CLASS_NAME);
    }

    Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (operationName == null) {
            throw JmxMessages.MESSAGES.nullVar("operationName");
        }
        if (params == null) {
            params = new Object[]{};
        }
        if (signature == null) {
            signature = new String[]{};
        }
        if (params.length != signature.length) {
            throw JmxMessages.MESSAGES.differentLengths("params", "signature");
        }
        RootResourceHack.ResourceAndRegistration reg = this.getRootResourceAndRegistration();
        PathAddress address = ObjectNameAddressUtil.resolvePathAddress(this.domain, reg.getResource(), name);
        if (address == null) {
            throw ModelControllerMBeanHelper.createInstanceNotFoundException(name);
        }
        ImmutableManagementResourceRegistration registration = this.getMBeanRegistration(address, reg);
        String realOperationName = null;
        OperationEntry opEntry = registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, operationName);
        if (opEntry != null) {
            realOperationName = operationName;
        } else {
            String opName = NameConverter.convertFromCamelCase(operationName);
            opEntry = registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, opName);
            if (opEntry != null) {
                realOperationName = opName;
            }
        }
        if (opEntry == null) {
            Map ops = registration.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, false);
            for (Map.Entry entry : ops.entrySet()) {
                if (!operationName.equals(NameConverter.convertToCamelCase((String)entry.getKey()))) continue;
                opEntry = (OperationEntry)entry.getValue();
                realOperationName = (String)entry.getKey();
                break;
            }
        }
        if (opEntry == null) {
            ChildAddOperationFinder.ChildAddOperationEntry entry = ChildAddOperationFinder.findAddChildOperation(reg.getRegistration().getSubModel(address), operationName);
            if (entry == null) {
                throw JmxMessages.MESSAGES.noOperationCalled(null, operationName, address);
            }
            PathElement element = entry.getElement();
            if (element.isWildcard()) {
                if (params.length == 0) {
                    throw JmxMessages.MESSAGES.wildcardNameParameterRequired();
                }
                element = PathElement.pathElement((String)element.getKey(), (String)((String)params[0]));
                Object[] newParams = new Object[params.length - 1];
                System.arraycopy(params, 1, newParams, 0, newParams.length);
                params = newParams;
            }
            return this.invoke(entry.getOperationEntry(), "add", address.append(new PathElement[]{element}), params);
        }
        return this.invoke(opEntry, realOperationName, address, params);
    }

    private Object invoke(OperationEntry entry, String operationName, PathAddress address, Object[] params) throws InstanceNotFoundException, MBeanException, ReflectionException {
        ModelNode result;
        String error;
        if (!this.standalone && !entry.getFlags().contains(OperationEntry.Flag.READ_ONLY)) {
            throw JmxMessages.MESSAGES.noOperationCalled(operationName);
        }
        ModelNode description = entry.getDescriptionProvider().getModelDescription(null);
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        op.get("address").set(address.toModelNode());
        if (params.length > 0) {
            ModelNode requestProperties = description.require("request-properties");
            Set keys = requestProperties.keys();
            if (keys.size() != params.length) {
                throw JmxMessages.MESSAGES.differentLengths("params", "description");
            }
            Iterator it = requestProperties.keys().iterator();
            for (int i = 0; i < params.length; ++i) {
                String attributeName = (String)it.next();
                ModelNode paramDescription = requestProperties.get(attributeName);
                op.get(attributeName).set(this.converters.toModelNode(paramDescription, params[i]));
            }
        }
        if ((error = this.getFailureDescription(result = this.execute(op))) != null) {
            throw new ReflectionException(null, error);
        }
        if (!description.hasDefined("reply-properties")) {
            return null;
        }
        return this.converters.fromModelNode(description.get("reply-properties"), result.get("result"));
    }

    static InstanceNotFoundException createInstanceNotFoundException(ObjectName name) {
        return JmxMessages.MESSAGES.mbeanNotFound(name);
    }

    private RootResourceHack.ResourceAndRegistration getRootResourceAndRegistration() {
        return RootResourceHack.INSTANCE.getRootResource(this.controller);
    }

    private ModelNode execute(ModelNode op) {
        return this.controller.execute(op, null, ModelController.OperationTransactionControl.COMMIT, null);
    }

    private ImmutableManagementResourceRegistration getMBeanRegistration(PathAddress address, RootResourceHack.ResourceAndRegistration reg) throws InstanceNotFoundException {
        ImmutableManagementResourceRegistration resourceRegistration = reg.getRegistration().getSubModel(address);
        if (resourceRegistration == null) {
            throw JmxMessages.MESSAGES.registrationNotFound(address);
        }
        return resourceRegistration;
    }

    private String getFailureDescription(ModelNode result) {
        if (result.hasDefined("failure-description")) {
            return result.get("failure-description").toString();
        }
        return null;
    }

    private String findAttributeName(ModelNode attributes, String attributeName) throws AttributeNotFoundException {
        if (attributes.hasDefined(attributeName)) {
            return attributeName;
        }
        for (String key : attributes.keys()) {
            if (!NameConverter.convertToCamelCase(key).equals(attributeName)) continue;
            return key;
        }
        throw JmxMessages.MESSAGES.attributeNotFound(attributeName);
    }

    private boolean isExcludeAddress(PathAddress pathAddress) {
        return pathAddress.equals(this.CORE_SERVICE_PLATFORM_MBEAN);
    }

    public static ObjectName createRootObjectName(String domain) {
        try {
            return ObjectName.getInstance(domain, "management-root", "server");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }
}

