/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.security.ModuleFlag;
import org.jboss.as.security.SecurityDomainReloadAddHandler;
import org.jboss.as.security.SecurityDomainReloadRemoveHandler;
import org.jboss.as.security.SecurityDomainReloadWriteHandler;
import org.jboss.as.security.SecurityExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LoginModuleResourceDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition CODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("code", ModelType.STRING).setRequired(true)).setMinSize(1)).build();
    static final SimpleAttributeDefinition FLAG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("flag", ModelType.STRING).setRequired(true)).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(ModuleFlag.class, false, true))).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).setRequired(false)).setAllowExpression(false)).setMinSize(1)).build();
    static final PropertiesAttributeDefinition MODULE_OPTIONS = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("module-options", true).setAllowExpression(true)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CODE, FLAG, MODULE, MODULE_OPTIONS};

    LoginModuleResourceDefinition(String key) {
        super(PathElement.pathElement((String)key), (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("login-module-stack", "login-modules"), (OperationStepHandler)new LoginModuleAdd(), (OperationStepHandler)new SecurityDomainReloadRemoveHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        SecurityDomainReloadWriteHandler writeHandler = new SecurityDomainReloadWriteHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    private static class LoginModuleAdd
    extends SecurityDomainReloadAddHandler {
        private LoginModuleAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : ATTRIBUTES) {
                attribute.validateAndSet(operation, model);
            }
        }
    }
}

