/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.CoordinatorEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import com.arjuna.ats.jbossatx.jts.TransactionManagerService;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.orbportability.internal.utils.PostInitLoader;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.service.internal.tsr.TransactionSynchronizationRegistryWrapper;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.TransactionManagerLocator;
import org.jboss.tm.usertx.UserTransactionRegistry;
import org.omg.CORBA.ORB;
import org.wildfly.transaction.client.LocalUserTransaction;

public final class ArjunaTransactionManagerService
implements Service<com.arjuna.ats.jbossatx.jta.TransactionManagerService> {
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_ARJUNA_TRANSACTION_MANAGER;
    private final InjectedValue<JBossXATerminator> xaTerminatorInjector = new InjectedValue();
    private final InjectedValue<ORB> orbInjector = new InjectedValue();
    private final InjectedValue<UserTransactionRegistry> userTransactionRegistry = new InjectedValue();
    private final InjectedValue<JTAEnvironmentBean> jtaEnvironmentBean = new InjectedValue();
    private com.arjuna.ats.jbossatx.jta.TransactionManagerService value;
    private ObjStoreBrowser objStoreBrowser;
    private boolean transactionStatusManagerEnable;
    private boolean coordinatorEnableStatistics;
    private int coordinatorDefaultTimeout;
    private final boolean jts;

    public ArjunaTransactionManagerService(boolean coordinatorEnableStatistics, int coordinatorDefaultTimeout, boolean transactionStatusManagerEnable, boolean jts) {
        this.coordinatorEnableStatistics = coordinatorEnableStatistics;
        this.coordinatorDefaultTimeout = coordinatorDefaultTimeout;
        this.transactionStatusManagerEnable = transactionStatusManagerEnable;
        this.jts = jts;
    }

    public synchronized void start(StartContext context) throws StartException {
        CoordinatorEnvironmentBean coordinatorEnvironmentBean = arjPropertyManager.getCoordinatorEnvironmentBean();
        coordinatorEnvironmentBean.setEnableStatistics(this.coordinatorEnableStatistics);
        coordinatorEnvironmentBean.setDefaultTimeout(this.coordinatorDefaultTimeout);
        coordinatorEnvironmentBean.setTransactionStatusManagerEnable(this.transactionStatusManagerEnable);
        TxControl.setDefaultTimeout((int)this.coordinatorDefaultTimeout);
        HashMap<String, String> objStoreBrowserTypes = new HashMap<String, String>();
        this.objStoreBrowser = new ObjStoreBrowser();
        objStoreBrowserTypes.put("StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.JTAActionBean");
        objStoreBrowserTypes.put("StateManager/AbstractRecord/ConnectableResourceRecord", "com.arjuna.ats.internal.jta.tools.osb.mbean.jta.ConnectableResourceRecordBean");
        if (!this.jts) {
            com.arjuna.ats.jbossatx.jta.TransactionManagerService service = new com.arjuna.ats.jbossatx.jta.TransactionManagerService();
            LocalUserTransaction userTransaction = LocalUserTransaction.getInstance();
            ((JTAEnvironmentBean)this.jtaEnvironmentBean.getValue()).setUserTransaction((UserTransaction)userTransaction);
            service.setJbossXATerminator((JBossXATerminator)this.xaTerminatorInjector.getValue());
            service.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)new TransactionSynchronizationRegistryWrapper());
            try {
                service.create();
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.managerStartFailure(e, "Transaction");
            }
            service.start();
            this.value = service;
        } else {
            ORB orb = (ORB)this.orbInjector.getValue();
            new PostInitLoader(PostInitLoader.generateORBPropertyName((String)"com.arjuna.orbportability.orb"), (Object)orb);
            TransactionManagerService service = new TransactionManagerService();
            LocalUserTransaction userTransaction = LocalUserTransaction.getInstance();
            ((JTAEnvironmentBean)this.jtaEnvironmentBean.getValue()).setUserTransaction((UserTransaction)userTransaction);
            service.setJbossXATerminator((JBossXATerminator)this.xaTerminatorInjector.getValue());
            service.setTransactionSynchronizationRegistry((TransactionSynchronizationRegistry)new TransactionSynchronizationRegistryWrapper());
            service.setPropagateFullContext(true);
            try {
                Field field = TransactionManagerLocator.class.getDeclaredField("tm");
                field.setAccessible(true);
                field.set(TransactionManagerLocator.getInstance(), ((JTAEnvironmentBean)this.jtaEnvironmentBean.getValue()).getTransactionManager());
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
            objStoreBrowserTypes.put("StateManager/BasicAction/TwoPhaseCoordinator/ArjunaTransactionImple", "com.arjuna.ats.arjuna.tools.osb.mbean.ActionBean");
            try {
                service.create();
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.createFailed(e);
            }
            try {
                service.start(orb);
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.startFailure(e);
            }
            this.value = service;
        }
        try {
            this.objStoreBrowser.start();
        }
        catch (Exception e) {
            throw TransactionLogger.ROOT_LOGGER.objectStoreStartFailure(e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.value.stop();
        this.value.destroy();
        this.objStoreBrowser.stop();
        this.value = null;
    }

    public synchronized com.arjuna.ats.jbossatx.jta.TransactionManagerService getValue() throws IllegalStateException {
        return TxnServices.notNull(this.value);
    }

    public Injector<JBossXATerminator> getXaTerminatorInjector() {
        return this.xaTerminatorInjector;
    }

    public Injector<ORB> getOrbInjector() {
        return this.orbInjector;
    }

    public InjectedValue<UserTransactionRegistry> getUserTransactionRegistry() {
        return this.userTransactionRegistry;
    }

    public Injector<JTAEnvironmentBean> getJTAEnvironmentBeanInjector() {
        return this.jtaEnvironmentBean;
    }
}

