/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.subsystem.LogStoreResource;
import org.jboss.as.txn.subsystem.TransactionExtension;
import org.jboss.dmr.ModelNode;

abstract class LogStoreParticipantOperationHandler
implements OperationStepHandler {
    private String operationName;

    public LogStoreParticipantOperationHandler(String operationName) {
        this.operationName = operationName;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        MBeanServer mbs = TransactionExtension.getMBeanServer(context);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        try {
            ObjectName on = LogStoreResource.getObjectName(resource);
            mbs.invoke(on, this.operationName, null, null);
        }
        catch (Exception e) {
            throw TransactionLogger.ROOT_LOGGER.jmxError(e.getMessage());
        }
        this.refreshParticipant(context);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    abstract void refreshParticipant(OperationContext var1);
}

