package org.wildfly.extension.undertow.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;
import org.jboss.jandex.AnnotationTarget;
import java.nio.file.Path;
import javax.annotation.Generated;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Integer;
import org.jboss.msc.service.ServiceName;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;
import java.io.File;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.jandex.ClassInfo;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-10-23T22:22:20-0500")
public class UndertowLogger_$logger extends DelegatingBasicLogger implements UndertowLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = UndertowLogger_$logger.class.getName();
    public UndertowLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void couldNotInitJsp(final ClassNotFoundException e) {
        super.log.logf(FQCN, ERROR, e, couldNotInitJsp$str());
    }
    private static final String couldNotInitJsp = "WFLYUT0001: Could not initialize JSP";
    protected String couldNotInitJsp$str() {
        return couldNotInitJsp;
    }
    @Override
    public final void serverStarting(final String version) {
        super.log.logf(FQCN, INFO, null, serverStarting$str(), version);
    }
    private static final String serverStarting = "WFLYUT0003: Undertow %s starting";
    protected String serverStarting$str() {
        return serverStarting;
    }
    @Override
    public final void serverStopping(final String version) {
        super.log.logf(FQCN, INFO, null, serverStopping$str(), version);
    }
    private static final String serverStopping = "WFLYUT0004: Undertow %s stopping";
    protected String serverStopping$str() {
        return serverStopping;
    }
    @Override
    public final void secureListenerNotAvailableForPort(final String protocol) {
        super.log.logf(FQCN, WARN, null, secureListenerNotAvailableForPort$str(), protocol);
    }
    private static final String secureListenerNotAvailableForPort = "WFLYUT0005: Secure listener for protocol: '%s' not found! Using non secure port!";
    protected String secureListenerNotAvailableForPort$str() {
        return secureListenerNotAvailableForPort;
    }
    @Override
    public final void listenerStarted(final String type, final String name, final String address, final int port) {
        super.log.logf(FQCN, INFO, null, listenerStarted$str(), type, name, address, port);
    }
    private static final String listenerStarted = "WFLYUT0006: Undertow %s listener %s listening on %s:%d";
    protected String listenerStarted$str() {
        return listenerStarted;
    }
    @Override
    public final void listenerStopped(final String type, final String name, final String address, final int port) {
        super.log.logf(FQCN, INFO, null, listenerStopped$str(), type, name, address, port);
    }
    private static final String listenerStopped = "WFLYUT0007: Undertow %s listener %s stopped, was bound to %s:%d";
    protected String listenerStopped$str() {
        return listenerStopped;
    }
    @Override
    public final void listenerSuspend(final String type, final String name) {
        super.log.logf(FQCN, INFO, null, listenerSuspend$str(), type, name);
    }
    private static final String listenerSuspend = "WFLYUT0008: Undertow %s listener %s suspending";
    protected String listenerSuspend$str() {
        return listenerSuspend;
    }
    @Override
    public final void cannotLoadDesignatedHandleTypes(final ClassInfo classInfo, final Exception e) {
        super.log.logf(FQCN, INFO, e, cannotLoadDesignatedHandleTypes$str(), classInfo);
    }
    private static final String cannotLoadDesignatedHandleTypes = "WFLYUT0009: Could not load class designated by HandlesTypes [%s].";
    protected String cannotLoadDesignatedHandleTypes$str() {
        return cannotLoadDesignatedHandleTypes;
    }
    @Override
    public final void couldNotLoadWebSocketEndpoint(final String s, final Exception e) {
        super.log.logf(FQCN, WARN, e, couldNotLoadWebSocketEndpoint$str(), s);
    }
    private static final String couldNotLoadWebSocketEndpoint = "WFLYUT0010: Could not load web socket endpoint %s.";
    protected String couldNotLoadWebSocketEndpoint$str() {
        return couldNotLoadWebSocketEndpoint;
    }
    @Override
    public final void couldNotLoadWebSocketConfig(final String s, final Exception e) {
        super.log.logf(FQCN, WARN, e, couldNotLoadWebSocketConfig$str(), s);
    }
    private static final String couldNotLoadWebSocketConfig = "WFLYUT0011: Could not load web socket application config %s.";
    protected String couldNotLoadWebSocketConfig$str() {
        return couldNotLoadWebSocketConfig;
    }
    @Override
    public final void startedServer(final String name) {
        super.log.logf(FQCN, INFO, null, startedServer$str(), name);
    }
    private static final String startedServer = "WFLYUT0012: Started server %s.";
    protected String startedServer$str() {
        return startedServer;
    }
    @Override
    public final void invalidRedirectURI(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, invalidRedirectURI$str());
    }
    private static final String invalidRedirectURI = "WFLYUT0013: Could not create redirect URI.";
    protected String invalidRedirectURI$str() {
        return invalidRedirectURI;
    }
    @Override
    public final void creatingFileHandler(final String path, final boolean directoryListing, final boolean followSymlink, final boolean caseSensitive, final java.util.List<String> safePaths) {
        super.log.logf(FQCN, INFO, null, creatingFileHandler$str(), path, directoryListing, followSymlink, caseSensitive, safePaths);
    }
    private static final String creatingFileHandler = "WFLYUT0014: Creating file handler for path '%s' with options [directory-listing: '%s', follow-symlink: '%s', case-sensitive: '%s', safe-symlink-paths: '%s']";
    protected String creatingFileHandler$str() {
        return creatingFileHandler;
    }
    @Override
    public final void invalidAbsoluteOrdering(final String name) {
        super.log.logf(FQCN, WARN, null, invalidAbsoluteOrdering$str(), name);
    }
    private static final String invalidAbsoluteOrdering = "WFLYUT0016: Could not resolve name in absolute ordering: %s";
    protected String invalidAbsoluteOrdering$str() {
        return invalidAbsoluteOrdering;
    }
    @Override
    public final void couldNotDeleteTempFile(final File file) {
        super.log.logf(FQCN, WARN, null, couldNotDeleteTempFile$str(), file);
    }
    private static final String couldNotDeleteTempFile = "WFLYUT0017: Could not delete servlet temp file %s";
    protected String couldNotDeleteTempFile$str() {
        return couldNotDeleteTempFile;
    }
    @Override
    public final void hostStarting(final String version) {
        super.log.logf(FQCN, INFO, null, hostStarting$str(), version);
    }
    private static final String hostStarting = "WFLYUT0018: Host %s starting";
    protected String hostStarting$str() {
        return hostStarting;
    }
    @Override
    public final void hostStopping(final String version) {
        super.log.logf(FQCN, INFO, null, hostStopping$str(), version);
    }
    private static final String hostStopping = "WFLYUT0019: Host %s stopping";
    protected String hostStopping$str() {
        return hostStopping;
    }
    @Override
    public final void clusteringNotSupported() {
        super.log.logf(FQCN, WARN, null, clusteringNotSupported$str());
    }
    private static final String clusteringNotSupported = "WFLYUT0020: Clustering not supported, falling back to non-clustered session manager";
    protected String clusteringNotSupported$str() {
        return clusteringNotSupported;
    }
    @Override
    public final void registerWebapp(final String webappPath, final String serverName) {
        super.log.logf(FQCN, INFO, null, registerWebapp$str(), webappPath, serverName);
    }
    private static final String registerWebapp = "WFLYUT0021: Registered web context: '%s' for server '%s'";
    protected String registerWebapp$str() {
        return registerWebapp;
    }
    @Override
    public final void unregisterWebapp(final String webappPath, final String serverName) {
        super.log.logf(FQCN, INFO, null, unregisterWebapp$str(), webappPath, serverName);
    }
    private static final String unregisterWebapp = "WFLYUT0022: Unregistered web context: '%s' from server '%s'";
    protected String unregisterWebapp$str() {
        return unregisterWebapp;
    }
    @Override
    public final void skippedSCI(final String jar, final Exception e) {
        super.log.logf(FQCN, INFO, e, skippedSCI$str(), jar);
    }
    private static final String skippedSCI = "WFLYUT0023: Skipped SCI for jar: %s.";
    protected String skippedSCI$str() {
        return skippedSCI;
    }
    @Override
    public final void failedToPersistSessionAttribute(final String attributeName, final Object value, final String sessionID, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedToPersistSessionAttribute$str(), attributeName, value, sessionID);
    }
    private static final String failedToPersistSessionAttribute = "WFLYUT0024: Failed to persist session attribute %s with value %s for session %s";
    protected String failedToPersistSessionAttribute$str() {
        return failedToPersistSessionAttribute;
    }
    @Override
    public final void failedToRegisterPolicyContextHandler(final String key, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToRegisterPolicyContextHandler$str(), key);
    }
    private static final String failedToRegisterPolicyContextHandler = "WFLYUT0025: Failed to register policy context handler for key %s";
    protected String failedToRegisterPolicyContextHandler$str() {
        return failedToRegisterPolicyContextHandler;
    }
    private static final String failToParseXMLDescriptor3 = "WFLYUT0027: Failed to parse XML descriptor %s at [%s,%s]";
    protected String failToParseXMLDescriptor3$str() {
        return failToParseXMLDescriptor3;
    }
    @Override
    public final String failToParseXMLDescriptor(final String xmlFile, final Integer line, final Integer column) {
        return String.format(getLoggingLocale(), failToParseXMLDescriptor3$str(), xmlFile, line, column);
    }
    private static final String failToParseXMLDescriptor1 = "WFLYUT0028: Failed to parse XML descriptor %s";
    protected String failToParseXMLDescriptor1$str() {
        return failToParseXMLDescriptor1;
    }
    @Override
    public final String failToParseXMLDescriptor(final String xmlFile) {
        return String.format(getLoggingLocale(), failToParseXMLDescriptor1$str(), xmlFile);
    }
    private static final String invalidWebServletAnnotation = "WFLYUT0029: @WebServlet is only allowed at class level %s";
    protected String invalidWebServletAnnotation$str() {
        return invalidWebServletAnnotation;
    }
    @Override
    public final String invalidWebServletAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidWebServletAnnotation$str(), target);
    }
    private static final String invalidWebInitParamAnnotation = "WFLYUT0030: @WebInitParam requires name and value on %s";
    protected String invalidWebInitParamAnnotation$str() {
        return invalidWebInitParamAnnotation;
    }
    @Override
    public final String invalidWebInitParamAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidWebInitParamAnnotation$str(), target);
    }
    private static final String invalidWebFilterAnnotation = "WFLYUT0031: @WebFilter is only allowed at class level %s";
    protected String invalidWebFilterAnnotation$str() {
        return invalidWebFilterAnnotation;
    }
    @Override
    public final String invalidWebFilterAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidWebFilterAnnotation$str(), target);
    }
    private static final String invalidWebListenerAnnotation = "WFLYUT0032: @WebListener is only allowed at class level %s";
    protected String invalidWebListenerAnnotation$str() {
        return invalidWebListenerAnnotation;
    }
    @Override
    public final String invalidWebListenerAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidWebListenerAnnotation$str(), target);
    }
    private static final String invalidRunAsAnnotation = "WFLYUT0033: @RunAs needs to specify a role name on %s";
    protected String invalidRunAsAnnotation$str() {
        return invalidRunAsAnnotation;
    }
    @Override
    public final String invalidRunAsAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidRunAsAnnotation$str(), target);
    }
    private static final String invalidDeclareRolesAnnotation = "WFLYUT0034: @DeclareRoles needs to specify role names on %s";
    protected String invalidDeclareRolesAnnotation$str() {
        return invalidDeclareRolesAnnotation;
    }
    @Override
    public final String invalidDeclareRolesAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidDeclareRolesAnnotation$str(), target);
    }
    private static final String invalidMultipartConfigAnnotation = "WFLYUT0035: @MultipartConfig is only allowed at class level %s";
    protected String invalidMultipartConfigAnnotation$str() {
        return invalidMultipartConfigAnnotation;
    }
    @Override
    public final String invalidMultipartConfigAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidMultipartConfigAnnotation$str(), target);
    }
    private static final String invalidServletSecurityAnnotation = "WFLYUT0036: @ServletSecurity is only allowed at class level %s";
    protected String invalidServletSecurityAnnotation$str() {
        return invalidServletSecurityAnnotation;
    }
    @Override
    public final String invalidServletSecurityAnnotation(final AnnotationTarget target) {
        return String.format(getLoggingLocale(), invalidServletSecurityAnnotation$str(), target);
    }
    private static final String wrongComponentType = "WFLYUT0037: %s has the wrong component type, it cannot be used as a web component";
    protected String wrongComponentType$str() {
        return wrongComponentType;
    }
    @Override
    public final RuntimeException wrongComponentType(final String clazz) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), wrongComponentType$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tldFileNotContainedInRoot = "WFLYUT0038: TLD file %s not contained in root %s";
    protected String tldFileNotContainedInRoot$str() {
        return tldFileNotContainedInRoot;
    }
    @Override
    public final String tldFileNotContainedInRoot(final String tldPath, final String rootPath) {
        return String.format(getLoggingLocale(), tldFileNotContainedInRoot$str(), tldPath, rootPath);
    }
    private static final String failedToResolveModule = "WFLYUT0039: Failed to resolve module for deployment %s";
    protected String failedToResolveModule$str() {
        return failedToResolveModule;
    }
    @Override
    public final DeploymentUnitProcessingException failedToResolveModule(final DeploymentUnit deploymentUnit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToResolveModule$str(), deploymentUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMultipleOthers = "WFLYUT0040: Duplicate others in absolute ordering";
    protected String invalidMultipleOthers$str() {
        return invalidMultipleOthers;
    }
    @Override
    public final String invalidMultipleOthers() {
        return String.format(getLoggingLocale(), invalidMultipleOthers$str());
    }
    private static final String invalidRelativeOrdering0 = "WFLYUT0041: Invalid relative ordering";
    protected String invalidRelativeOrdering0$str() {
        return invalidRelativeOrdering0;
    }
    @Override
    public final String invalidRelativeOrdering() {
        return String.format(getLoggingLocale(), invalidRelativeOrdering0$str());
    }
    private static final String invalidWebFragment = "WFLYUT0042: Conflict occurred processing web fragment in JAR: %s";
    protected String invalidWebFragment$str() {
        return invalidWebFragment;
    }
    @Override
    public final String invalidWebFragment(final String jar) {
        return String.format(getLoggingLocale(), invalidWebFragment$str(), jar);
    }
    private static final String invalidRelativeOrdering1 = "WFLYUT0043: Relative ordering processing error with JAR: %s";
    protected String invalidRelativeOrdering1$str() {
        return invalidRelativeOrdering1;
    }
    @Override
    public final String invalidRelativeOrdering(final String jar) {
        return String.format(getLoggingLocale(), invalidRelativeOrdering1$str(), jar);
    }
    private static final String invalidRelativeOrderingBeforeAndAfter = "WFLYUT0044: Ordering includes both before and after others in JAR: %s";
    protected String invalidRelativeOrderingBeforeAndAfter$str() {
        return invalidRelativeOrderingBeforeAndAfter;
    }
    @Override
    public final String invalidRelativeOrderingBeforeAndAfter(final String jar) {
        return String.format(getLoggingLocale(), invalidRelativeOrderingBeforeAndAfter$str(), jar);
    }
    private static final String invalidRelativeOrderingDuplicateName = "WFLYUT0045: Duplicate name declared in JAR: %s";
    protected String invalidRelativeOrderingDuplicateName$str() {
        return invalidRelativeOrderingDuplicateName;
    }
    @Override
    public final String invalidRelativeOrderingDuplicateName(final String jar) {
        return String.format(getLoggingLocale(), invalidRelativeOrderingDuplicateName$str(), jar);
    }
    @Override
    public final void invalidRelativeOrderingUnknownName(final String jar) {
        super.log.logf(FQCN, WARN, null, invalidRelativeOrderingUnknownName$str(), jar);
    }
    private static final String invalidRelativeOrderingUnknownName = "WFLYUT0046: Unknown web fragment name declared in JAR: %s";
    protected String invalidRelativeOrderingUnknownName$str() {
        return invalidRelativeOrderingUnknownName;
    }
    private static final String invalidRelativeOrderingConflict = "WFLYUT0047: Relative ordering conflict with JAR: %s";
    protected String invalidRelativeOrderingConflict$str() {
        return invalidRelativeOrderingConflict;
    }
    @Override
    public final String invalidRelativeOrderingConflict(final String jar) {
        return String.format(getLoggingLocale(), invalidRelativeOrderingConflict$str(), jar);
    }
    private static final String failToProcessWebInfLib = "WFLYUT0048: Failed to process WEB-INF/lib: %s";
    protected String failToProcessWebInfLib$str() {
        return failToProcessWebInfLib;
    }
    @Override
    public final String failToProcessWebInfLib(final VirtualFile xmlFile) {
        return String.format(getLoggingLocale(), failToProcessWebInfLib$str(), xmlFile);
    }
    private static final String errorLoadingSCIFromModule = "WFLYUT0049: Error loading SCI from module: %s";
    protected String errorLoadingSCIFromModule$str() {
        return errorLoadingSCIFromModule;
    }
    @Override
    public final DeploymentUnitProcessingException errorLoadingSCIFromModule(final String identifier, final Exception e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), errorLoadingSCIFromModule$str(), identifier), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToResolveAnnotationIndex = "WFLYUT0050: Unable to resolve annotation index for deployment unit: %s";
    protected String unableToResolveAnnotationIndex$str() {
        return unableToResolveAnnotationIndex;
    }
    @Override
    public final DeploymentUnitProcessingException unableToResolveAnnotationIndex(final DeploymentUnit deploymentUnit) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), unableToResolveAnnotationIndex$str(), deploymentUnit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorProcessingSCI = "WFLYUT0051: Deployment error processing SCI for jar: %s";
    protected String errorProcessingSCI$str() {
        return errorProcessingSCI;
    }
    @Override
    public final DeploymentUnitProcessingException errorProcessingSCI(final String jar, final Exception e) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), errorProcessingSCI$str(), jar), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failToCreateSecurityContext = "WFLYUT0052: Security context creation failed";
    protected String failToCreateSecurityContext$str() {
        return failToCreateSecurityContext;
    }
    @Override
    public final RuntimeException failToCreateSecurityContext(final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failToCreateSecurityContext$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSecurityContext = "WFLYUT0053: No security context found";
    protected String noSecurityContext$str() {
        return noSecurityContext;
    }
    @Override
    public final IllegalStateException noSecurityContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSecurityContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMetric = "WFLYUT0054: Unknown metric %s";
    protected String unknownMetric$str() {
        return unknownMetric;
    }
    @Override
    public final String unknownMetric(final Object metric) {
        return String.format(getLoggingLocale(), unknownMetric$str(), metric);
    }
    private static final String nullDefaultHost = "WFLYUT0055: Null default host";
    protected String nullDefaultHost$str() {
        return nullDefaultHost;
    }
    @Override
    public final IllegalArgumentException nullDefaultHost() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullDefaultHost$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullHostName = "WFLYUT0056: Null host name";
    protected String nullHostName$str() {
        return nullHostName;
    }
    @Override
    public final IllegalStateException nullHostName() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nullHostName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullParamter = "WFLYUT0057: Null parameter %s";
    protected String nullParamter$str() {
        return nullParamter;
    }
    @Override
    public final IllegalArgumentException nullParamter(final String id) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParamter$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotActivateContext = "WFLYUT0058: Cannot activate context: %s";
    protected String cannotActivateContext$str() {
        return cannotActivateContext;
    }
    @Override
    public final IllegalStateException cannotActivateContext(final Throwable th, final ServiceName service) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotActivateContext$str(), service), th);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateHttpHandler = "WFLYUT0059: Could not construct handler for class: %s. with parameters %s";
    protected String cannotCreateHttpHandler$str() {
        return cannotCreateHttpHandler;
    }
    @Override
    public final RuntimeException cannotCreateHttpHandler(final Class<?> handlerClass, final ModelNode parameters, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotCreateHttpHandler$str(), handlerClass, parameters), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPersistentSessionDir = "WFLYUT0060: Invalid persistent sessions directory %s";
    protected String invalidPersistentSessionDir$str() {
        return invalidPersistentSessionDir;
    }
    @Override
    public final StartException invalidPersistentSessionDir(final File baseDir) {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidPersistentSessionDir$str(), baseDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreatePersistentSessionDir = "WFLYUT0061: Failed to create persistent sessions dir %s";
    protected String failedToCreatePersistentSessionDir$str() {
        return failedToCreatePersistentSessionDir;
    }
    @Override
    public final StartException failedToCreatePersistentSessionDir(final File baseDir) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToCreatePersistentSessionDir$str(), baseDir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotCreateLogDirectory = "WFLYUT0062: Could not create log directory: %s";
    protected String couldNotCreateLogDirectory$str() {
        return couldNotCreateLogDirectory;
    }
    @Override
    public final StartException couldNotCreateLogDirectory(final Path directory, final IOException e) {
        final StartException result = new StartException(String.format(getLoggingLocale(), couldNotCreateLogDirectory$str(), directory), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPortListeningForProtocol = "WFLYUT0063: Could not find the port number listening for protocol %s";
    protected String noPortListeningForProtocol$str() {
        return noPortListeningForProtocol;
    }
    @Override
    public final IllegalStateException noPortListeningForProtocol(final String protocol) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noPortListeningForProtocol$str(), protocol));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToConfigureHandler = "WFLYUT0064: Failed to configure handler %s";
    protected String failedToConfigureHandler$str() {
        return failedToConfigureHandler;
    }
    @Override
    public final RuntimeException failedToConfigureHandler(final Class<?> handlerClass, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToConfigureHandler$str(), handlerClass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerWasNotAHandlerOrWrapper = "WFLYUT0065: Handler class %s was not a handler or a wrapper";
    protected String handlerWasNotAHandlerOrWrapper$str() {
        return handlerWasNotAHandlerOrWrapper;
    }
    @Override
    public final IllegalArgumentException handlerWasNotAHandlerOrWrapper(final Class<?> handlerClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), handlerWasNotAHandlerOrWrapper$str(), handlerClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToConfigureHandlerClass = "WFLYUT0066: Failed to configure handler %s";
    protected String failedToConfigureHandlerClass$str() {
        return failedToConfigureHandlerClass;
    }
    @Override
    public final RuntimeException failedToConfigureHandlerClass(final String handlerClass, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToConfigureHandlerClass$str(), handlerClass), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String servletClassNotDefined = "WFLYUT0067: Servlet class not defined for servlet %s";
    protected String servletClassNotDefined$str() {
        return servletClassNotDefined;
    }
    @Override
    public final IllegalArgumentException servletClassNotDefined(final String servletName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), servletClassNotDefined$str(), servletName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noAuthorizationHelper(final Exception e) {
        super.log.logf(FQCN, ERROR, e, noAuthorizationHelper$str());
    }
    private static final String noAuthorizationHelper = "WFLYUT0068: Error obtaining authorization helper";
    protected String noAuthorizationHelper$str() {
        return noAuthorizationHelper;
    }
    @Override
    public final void sharedSessionConfigNotInRootDeployment(final String deployment) {
        super.log.logf(FQCN, ERROR, null, sharedSessionConfigNotInRootDeployment$str(), deployment);
    }
    private static final String sharedSessionConfigNotInRootDeployment = "WFLYUT0069: Ignoring shared-session-config in jboss-all.xml in deployment %s. This entry is only valid in top level deployments.";
    protected String sharedSessionConfigNotInRootDeployment$str() {
        return sharedSessionConfigNotInRootDeployment;
    }
    private static final String couldNotLoadHandlerFromModule = "WFLYUT0070: Could not load handler %s from %s module";
    protected String couldNotLoadHandlerFromModule$str() {
        return couldNotLoadHandlerFromModule;
    }
    @Override
    public final RuntimeException couldNotLoadHandlerFromModule(final String className, final String moduleName, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotLoadHandlerFromModule$str(), className, moduleName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void alpnNotFound(final String listener) {
        super.log.logf(FQCN, WARN, null, alpnNotFound$str(), listener);
    }
    private static final String alpnNotFound = "WFLYUT0071: No ALPN provider found, HTTP/2 will not be enabled. To remove this message set enable-http2 to false on the listener %s in the Undertow subsystem.";
    protected String alpnNotFound$str() {
        return alpnNotFound;
    }
    private static final String couldNotFindExternalPath = "WFLYUT0072: Could not find configured external path %s";
    protected String couldNotFindExternalPath$str() {
        return couldNotFindExternalPath;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotFindExternalPath(final File path) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotFindExternalPath$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String advertiseSocketBindingRequiresMulticastAddress = "WFLYUT0073: mod_cluster advertise socket binding requires multicast address to be set";
    protected String advertiseSocketBindingRequiresMulticastAddress$str() {
        return advertiseSocketBindingRequiresMulticastAddress;
    }
    @Override
    public final StartException advertiseSocketBindingRequiresMulticastAddress() {
        final StartException result = new StartException(String.format(getLoggingLocale(), advertiseSocketBindingRequiresMulticastAddress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void tldNotFound(final String location) {
        super.log.logf(FQCN, ERROR, null, tldNotFound$str(), location);
    }
    private static final String tldNotFound = "WFLYUT0074: Could not find TLD %s";
    protected String tldNotFound$str() {
        return tldNotFound;
    }
    private static final String cannotRegisterResourceOfType = "WFLYUT0075: Cannot register resource of type %s";
    protected String cannotRegisterResourceOfType$str() {
        return cannotRegisterResourceOfType;
    }
    @Override
    public final IllegalArgumentException cannotRegisterResourceOfType(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotRegisterResourceOfType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveResourceOfType = "WFLYUT0076: Cannot remove resource of type %s";
    protected String cannotRemoveResourceOfType$str() {
        return cannotRemoveResourceOfType;
    }
    @Override
    public final IllegalArgumentException cannotRemoveResourceOfType(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotRemoveResourceOfType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToRegisterWebsocket(final Class endpoint, final String path, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToRegisterWebsocket$str(), endpoint, path);
    }
    private static final String failedToRegisterWebsocket = "WFLYUT0078: Failed to register management view for websocket %s at %s";
    protected String failedToRegisterWebsocket$str() {
        return failedToRegisterWebsocket;
    }
    @Override
    public final void errorInvokingSecureResponse(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorInvokingSecureResponse$str());
    }
    private static final String errorInvokingSecureResponse = "WFLYUT0077: Error invoking secure response";
    protected String errorInvokingSecureResponse$str() {
        return errorInvokingSecureResponse;
    }
    private static final String noSslContextInSecurityRealm = "WFLYUT0079: No SSL Context available from security realm '%s'. Either the realm is not configured for SSL, or the server has not been reloaded since the SSL config was added.";
    protected String noSslContextInSecurityRealm$str() {
        return noSslContextInSecurityRealm;
    }
    @Override
    public final IllegalStateException noSslContextInSecurityRealm(final String securityRealm) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSslContextInSecurityRealm$str(), securityRealm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unsupportedValveFeature(final String valve) {
        super.log.logf(FQCN, WARN, null, unsupportedValveFeature$str(), valve);
    }
    private static final String unsupportedValveFeature = "WFLYUT0080: Valves are no longer supported, %s is not activated.";
    protected String unsupportedValveFeature$str() {
        return unsupportedValveFeature;
    }
    @Override
    public final void distributableDisabledInFragmentXml(final String deployment, final String module) {
        super.log.logf(FQCN, WARN, null, distributableDisabledInFragmentXml$str(), deployment, module);
    }
    private static final String distributableDisabledInFragmentXml = "WFLYUT0081: The deployment %s will not be distributable because this feature is disabled in web-fragment.xml of the module %s.";
    protected String distributableDisabledInFragmentXml$str() {
        return distributableDisabledInFragmentXml;
    }
    private static final String couldNotStartListener = "WFLYUT0082: Could not start '%s' listener.";
    protected String couldNotStartListener$str() {
        return couldNotStartListener;
    }
    @Override
    public final StartException couldNotStartListener(final String name, final IOException e) {
        final StartException result = new StartException(String.format(getLoggingLocale(), couldNotStartListener$str(), name), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullNotAllowed = "WFLYUT0083: %s is not allowed to be null";
    protected String nullNotAllowed$str() {
        return nullNotAllowed;
    }
    @Override
    public final String nullNotAllowed(final String name) {
        return String.format(getLoggingLocale(), nullNotAllowed$str(), name);
    }
    private static final String noMechanismsAvailable = "WFLYUT0084: There are no mechanisms available from the HttpAuthenticationFactory.";
    protected String noMechanismsAvailable$str() {
        return noMechanismsAvailable;
    }
    @Override
    public final IllegalStateException noMechanismsAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMechanismsAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredMechanismNotAvailable = "WFLYUT0085: The required mechanism '%s' is not available in mechanisms %s from the HttpAuthenticationFactory.";
    protected String requiredMechanismNotAvailable$str() {
        return requiredMechanismNotAvailable;
    }
    @Override
    public final IllegalStateException requiredMechanismNotAvailable(final String mechanismName, final java.util.Collection<String> availableMechanisms) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), requiredMechanismNotAvailable$str(), mechanismName, availableMechanisms));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMechanismsSelected = "WFLYUT0086: No authentication mechanisms have been selected.";
    protected String noMechanismsSelected$str() {
        return noMechanismsSelected;
    }
    @Override
    public final IllegalStateException noMechanismsSelected() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMechanismsSelected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateDefaultWebModuleMapping = "WFLYUT0087: Duplicate default web module '%s' configured on server '%s', host '%s'";
    protected String duplicateDefaultWebModuleMapping$str() {
        return duplicateDefaultWebModuleMapping;
    }
    @Override
    public final IllegalArgumentException duplicateDefaultWebModuleMapping(final String defaultDeploymentName, final String serverName, final String hostName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), duplicateDefaultWebModuleMapping$str(), defaultDeploymentName, serverName, hostName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String predicateNotValid = "WFLYUT0089: Predicate %s was not valid, message was: %s";
    protected String predicateNotValid$str() {
        return predicateNotValid;
    }
    @Override
    public final String predicateNotValid(final String predicate, final String error) {
        return String.format(getLoggingLocale(), predicateNotValid$str(), predicate, error);
    }
    private static final String missingKeyStoreEntry = "WFLYUT0090: Key alias %s does not exist in the configured key store";
    protected String missingKeyStoreEntry$str() {
        return missingKeyStoreEntry;
    }
    @Override
    public final IllegalArgumentException missingKeyStoreEntry(final String alias) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingKeyStoreEntry$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreEntryNotPrivate = "WFLYUT0091: Key store entry %s is not a private key entry";
    protected String keyStoreEntryNotPrivate$str() {
        return keyStoreEntryNotPrivate;
    }
    @Override
    public final IllegalArgumentException keyStoreEntryNotPrivate(final String alias) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), keyStoreEntryNotPrivate$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCredential = "WFLYUT0092: Credential alias %s does not exist in the configured credential store";
    protected String missingCredential$str() {
        return missingCredential;
    }
    @Override
    public final IllegalArgumentException missingCredential(final String alias) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingCredential$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialNotClearPassword = "WFLYUT0093: Credential %s is not a clear text password";
    protected String credentialNotClearPassword$str() {
        return credentialNotClearPassword;
    }
    @Override
    public final IllegalArgumentException credentialNotClearPassword(final String alias) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), credentialNotClearPassword$str(), alias));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void configurationOptionIgnoredWhenUsingElytron(final String option) {
        super.log.logf(FQCN, WARN, null, configurationOptionIgnoredWhenUsingElytron$str(), option);
    }
    private static final String configurationOptionIgnoredWhenUsingElytron = "WFLYUT0094: Configuration option [%s] ignored when using Elytron subsystem";
    protected String configurationOptionIgnoredWhenUsingElytron$str() {
        return configurationOptionIgnoredWhenUsingElytron;
    }
    private static final String unableAddHandlerForPath = "WFLYUT0095: the path ['%s'] doesn't exist on file system";
    protected String unableAddHandlerForPath$str() {
        return unableAddHandlerForPath;
    }
    @Override
    public final String unableAddHandlerForPath(final String path) {
        return String.format(getLoggingLocale(), unableAddHandlerForPath$str(), path);
    }
    private static final String unableToObtainIdentity = "WFLYUT0096: Unable to obtain identity for name %s";
    protected String unableToObtainIdentity$str() {
        return unableToObtainIdentity;
    }
    @Override
    public final IllegalStateException unableToObtainIdentity(final String name, final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToObtainIdentity$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String workerValueInHTTPListenerMustMatchRemoting = "WFLYUT0097: If http-upgrade is enabled, remoting worker and http(s) worker must be the same. Please adjust values if need be.";
    protected String workerValueInHTTPListenerMustMatchRemoting$str() {
        return workerValueInHTTPListenerMustMatchRemoting;
    }
    @Override
    public final String workerValueInHTTPListenerMustMatchRemoting() {
        return String.format(getLoggingLocale(), workerValueInHTTPListenerMustMatchRemoting$str());
    }
}
