/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.ee.component.deployers.StartupCountdown;

public class ComponentStartupCountdownHandler
implements HttpHandler {
    private final HttpHandler wrappedHandler;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final HttpHandler startupFailedHandler = ResponseCodeHandler.HANDLE_500;

    public ComponentStartupCountdownHandler(HttpHandler handler, StartupCountdown countdown) {
        this.wrappedHandler = handler;
        countdown.addCallback(() -> this.started.set(true));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.started.get()) {
            this.wrappedHandler.handleRequest(exchange);
        } else {
            Connectors.executeRootHandler((HttpHandler)this.startupFailedHandler, (HttpServerExchange)exchange);
        }
    }
}

