/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.session;

import java.nio.CharBuffer;
import java.util.AbstractMap;
import java.util.Map;
import org.jboss.as.web.session.CompositeCharSequence;
import org.jboss.as.web.session.RoutingSupport;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SimpleRoutingSupport
implements RoutingSupport {
    private static final String DELIMITER = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.session.route.delimiter", (String)".");

    @Override
    public Map.Entry<CharSequence, CharSequence> parse(CharSequence id) {
        if (id != null) {
            int length = id.length();
            int delimiterLength = DELIMITER.length();
            for (int i = 0; i <= length - delimiterLength; ++i) {
                int routeStart = i + delimiterLength;
                if (!DELIMITER.contentEquals(id.subSequence(i, routeStart))) continue;
                return new AbstractMap.SimpleImmutableEntry<CharSequence, CharSequence>(CharBuffer.wrap(id, 0, i), CharBuffer.wrap(id, routeStart, length));
            }
        }
        return new AbstractMap.SimpleImmutableEntry<CharSequence, Object>(id, null);
    }

    @Override
    public CharSequence format(CharSequence sessionId, CharSequence routeId) {
        if (routeId == null || routeId.length() == 0) {
            return sessionId;
        }
        return new CompositeCharSequence(sessionId, DELIMITER, routeId);
    }
}

