/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.format;

import wiremock.com.ethlo.time.ITU;
import wiremock.com.ethlo.time.LeapSecondException;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.Format;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DateTimeFormat
implements Format {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeFormat.class);

    @Override
    public String getName() {
        return "date-time";
    }

    @Override
    public String getMessageKey() {
        return "format.date-time";
    }

    @Override
    public boolean matches(ExecutionContext executionContext, String value) {
        return DateTimeFormat.isLegalDateTime(value);
    }

    private static boolean isLegalDateTime(String string) {
        try {
            block4: {
                try {
                    ITU.parseDateTime(string);
                }
                catch (LeapSecondException ex) {
                    if (ex.isVerifiedValidLeapYearMonth()) break block4;
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.debug("Invalid {}: {}", (Object)"date-time", (Object)ex.getMessage());
            return false;
        }
    }
}

