/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;

public class Exceptions {
    public static <T> T throwUnchecked(Throwable ex, Class<T> returnType) {
        Exceptions.throwsUnchecked(ex);
        throw new AssertionError((Object)"This code should be unreachable. Something went terribly wrong here!");
    }

    public static void throwUnchecked(Throwable ex) {
        Exceptions.throwUnchecked(ex, null);
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable toThrow) throws T {
        throw toThrow;
    }

    public static <T> T uncheck(Callable<T> work, Class<T> returnType) {
        try {
            return work.call();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, returnType);
        }
    }

    public static void uncheck(RunnableWithException work) {
        try {
            work.run();
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    public static String renderStackTrace(Throwable t2) {
        StringWriter sw = new StringWriter();
        t2.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

