/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class Scenario {
    public static final String STARTED = "Started";
    private final String id;
    private final String state;
    private final Set<StubMapping> stubMappings;

    @JsonCreator
    public Scenario(@JsonProperty(value="id") String id, @JsonProperty(value="name") String ignored, @JsonProperty(value="state") String currentState, @JsonProperty(value="possibleStates") Set<String> ignored2, @JsonProperty(value="mappings") Set<StubMapping> stubMappings) {
        this.id = id;
        this.state = currentState;
        this.stubMappings = stubMappings;
    }

    private Scenario(String id, String state, Set<StubMapping> stubMappings) {
        this(id, null, state, null, stubMappings);
    }

    public static Scenario inStartedState(String name) {
        return new Scenario(name, STARTED, Collections.emptySet());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public String getState() {
        return this.state;
    }

    public Set<String> getPossibleStates() {
        List requiredStates = this.stubMappings.stream().map(StubMapping::getRequiredScenarioState).collect(Collectors.toList());
        requiredStates.addAll(this.stubMappings.stream().map(StubMapping::getNewScenarioState).collect(Collectors.toList()));
        return requiredStates.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<StubMapping> getMappings() {
        return this.stubMappings;
    }

    Scenario setState(String newState) {
        if (!this.getPossibleStates().contains(newState)) {
            throw new InvalidInputException(Errors.single(11, "Scenario " + this.id + " does not support state " + newState));
        }
        return new Scenario(this.id, newState, this.stubMappings);
    }

    Scenario reset() {
        return new Scenario(this.id, STARTED, this.stubMappings);
    }

    Scenario withStubMapping(StubMapping stubMapping) {
        LinkedHashSet<StubMapping> newMappings = new LinkedHashSet<StubMapping>(this.stubMappings);
        newMappings.add(stubMapping);
        return new Scenario(this.id, this.state, newMappings);
    }

    Scenario withoutStubMapping(StubMapping stubMapping) {
        Set<StubMapping> newMappings = this.stubMappings.stream().filter(stub -> !stub.getId().equals(stubMapping.getId())).collect(Collectors.toSet());
        return new Scenario(this.id, this.state, newMappings);
    }

    public String toString() {
        return Json.write(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return Objects.equals(this.getId(), scenario.getId()) && Objects.equals(this.getState(), scenario.getState()) && Objects.equals(this.getMappings(), scenario.getMappings());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getState(), this.getMappings());
    }

    public static Predicate<Scenario> withName(String name) {
        return input -> input.getId().equals(name);
    }
}

