/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DependenciesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependenciesValidator.class);
    private final Map<String, List<String>> propertyDeps = new HashMap<String, List<String>>();
    private final Map<String, JsonSchema> schemaDeps = new HashMap<String, JsonSchema>();

    public DependenciesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENCIES, validationContext);
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (pvalue.isArray()) {
                List<String> depsProps = this.propertyDeps.get(pname);
                if (depsProps == null) {
                    depsProps = new ArrayList<String>();
                    this.propertyDeps.put(pname, depsProps);
                }
                for (int i = 0; i < pvalue.size(); ++i) {
                    depsProps.add(pvalue.get(i).asText());
                }
                continue;
            }
            if (!pvalue.isObject() && !pvalue.isBoolean()) continue;
            this.schemaDeps.put(pname, validationContext.newSchema(schemaLocation.append(pname), evaluationPath.append(pname), pvalue, parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        DependenciesValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        LinkedHashSet<ValidationMessage> errors = null;
        Iterator<String> it = node.fieldNames();
        while (it.hasNext()) {
            Set<ValidationMessage> schemaDepsErrors;
            JsonSchema schema;
            String pname = it.next();
            List<String> deps = this.propertyDeps.get(pname);
            if (deps != null && !deps.isEmpty()) {
                for (String field : deps) {
                    if (node.get(field) != null) continue;
                    if (errors == null) {
                        errors = new LinkedHashSet<ValidationMessage>();
                    }
                    errors.add(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).property(pname)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(this.propertyDeps.toString())).build());
                }
            }
            if ((schema = this.schemaDeps.get(pname)) == null || (schemaDepsErrors = schema.validate(executionContext, node, rootNode, instanceLocation)).isEmpty()) continue;
            if (errors == null) {
                errors = new LinkedHashSet();
            }
            errors.addAll(schemaDepsErrors);
        }
        return errors == null || errors.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(errors);
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemaDeps.values());
    }
}

