/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CachedSupplier;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.InvalidSchemaRefException;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaRef;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class RecursiveRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RecursiveRefValidator.class);
    protected final JsonSchemaRef schema;

    public RecursiveRefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.RECURSIVE_REF, validationContext);
        String refValue = schemaNode.asText();
        if (!"#".equals(refValue)) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.RECURSIVE_REF.getValue())).code("internal.invalidRecursiveRef")).message("{0}: The value of a $recursiveRef must be '#' but is '{1}'")).instanceLocation(schemaLocation.getFragment())).instanceNode(this.schemaNode)).evaluationPath(evaluationPath)).arguments(refValue)).build();
            throw new JsonSchemaException(validationMessage);
        }
        this.schema = RecursiveRefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        return new JsonSchemaRef(RecursiveRefValidator.getSupplier(() -> RecursiveRefValidator.getSchema(parentSchema, validationContext, refValue, evaluationPath), validationContext.getConfig().isCacheRefs()));
    }

    static <T> Supplier<T> getSupplier(Supplier<T> supplier, boolean cache) {
        return cache ? new CachedSupplier(supplier) : supplier;
    }

    static JsonSchema getSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        JsonSchema refSchema;
        JsonSchema current = refSchema = parentSchema.findSchemaResourceRoot();
        JsonSchema check = null;
        String base = null;
        String baseCheck = null;
        if (refSchema != null) {
            String string = base = current.getSchemaLocation().getAbsoluteIri() != null ? current.getSchemaLocation().getAbsoluteIri().toString() : "";
        }
        if (current.isRecursiveAnchor()) {
            while (current.getEvaluationParentSchema() != null) {
                baseCheck = (current = current.getEvaluationParentSchema()).getSchemaLocation().getAbsoluteIri() != null ? current.getSchemaLocation().getAbsoluteIri().toString() : "";
                if (base.equals(baseCheck)) continue;
                base = baseCheck;
                check = current.findSchemaResourceRoot();
                if (!check.isRecursiveAnchor()) continue;
                refSchema = check;
            }
        }
        if (refSchema != null) {
            refSchema = refSchema.fromRef(parentSchema, evaluationPath);
        }
        return refSchema;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        RecursiveRefValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.RECURSIVE_REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        return refSchema.validate(executionContext, node, rootNode, instanceLocation);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        RecursiveRefValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.RECURSIVE_REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        if (node == null) {
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            JsonSchema check = refSchema;
            boolean circularDependency = false;
            while (check.getEvaluationParentSchema() != null) {
                if (!(check = check.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return Collections.emptySet();
            }
        }
        return refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        JsonSchema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonSchemaException(e);
        }
        SchemaLocation schemaLocation = jsonSchema.getSchemaLocation();
        JsonSchema check = jsonSchema;
        boolean circularDependency = false;
        int depth = 0;
        while (check.getEvaluationParentSchema() != null) {
            ++depth;
            if (!(check = check.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
            circularDependency = true;
            break;
        }
        if (this.validationContext.getConfig().isCacheRefs() && !circularDependency && depth < this.validationContext.getConfig().getPreloadJsonSchemaRefMaxNestingDepth()) {
            jsonSchema.initializeValidators();
        }
    }
}

