/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import org.wiztools.commons.CollectionsUtil;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.MultiValueMapArrayList;
import org.wiztools.restclient.Response;
import org.wiztools.restclient.TestResult;

public final class ResponseBean
implements Response {
    private int statusCode;
    private String statusLine;
    private MultiValueMap<String, String> headers = new MultiValueMapArrayList();
    private String responseBody;
    private TestResult testResult;
    private long executionTime;

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public MultiValueMap<String, String> getHeaders() {
        return CollectionsUtil.unmodifiableMultiValueMap(this.headers);
    }

    public void addHeader(String key, String value) {
        this.headers.put((Object)key, (Object)value);
    }

    @Override
    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    @Override
    public String getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(String statusLine) {
        this.statusLine = statusLine;
    }

    @Override
    public TestResult getTestResult() {
        return this.testResult;
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    @Override
    public Object clone() {
        ResponseBean response = new ResponseBean();
        response.executionTime = this.executionTime;
        response.statusCode = this.statusCode;
        response.statusLine = this.statusLine;
        response.responseBody = this.responseBody;
        if (this.headers.size() != 0) {
            for (String header : this.headers.keySet()) {
                for (String value : this.headers.get((Object)header)) {
                    response.addHeader(header, value);
                }
            }
        }
        return response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Response) {
            Response bean = (Response)o;
            boolean isEqual = true;
            boolean bl = isEqual = isEqual && this.statusCode == bean.getStatusCode();
            boolean bl2 = isEqual && (this.statusLine == null ? bean.getStatusLine() == null : this.statusLine.equals(bean.getStatusLine())) ? true : (isEqual = false);
            boolean bl3 = isEqual && (this.headers == null ? bean.getHeaders() == null : this.headers.equals(bean.getHeaders())) ? true : (isEqual = false);
            boolean bl4 = isEqual && (this.responseBody == null ? bean.getResponseBody() == null : this.responseBody.equals(bean.getResponseBody())) ? true : (isEqual = false);
            isEqual = isEqual && (this.testResult == null ? bean.getTestResult() == null : this.testResult.equals(bean.getTestResult()));
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.statusCode;
        hash = 53 * hash + (this.statusLine != null ? this.statusLine.hashCode() : 0);
        hash = 53 * hash + (this.headers != null ? this.headers.hashCode() : 0);
        hash = 53 * hash + (this.responseBody != null ? this.responseBody.hashCode() : 0);
        hash = 53 * hash + (this.testResult != null ? this.testResult.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@Response[");
        sb.append(this.statusLine);
        sb.append("]");
        return sb.toString();
    }
}

