/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyTestSuite;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.codehaus.groovy.control.CompilationFailedException;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.RESTTestCase;
import org.wiztools.restclient.Request;
import org.wiztools.restclient.Response;
import org.wiztools.restclient.RoRequestBean;
import org.wiztools.restclient.RoResponseBean;
import org.wiztools.restclient.TestException;
import org.wiztools.restclient.TestFailureResult;
import org.wiztools.restclient.TestFailureResultBean;
import org.wiztools.restclient.TestResult;
import org.wiztools.restclient.TestResultBean;

public class TestUtil {
    private static final Logger LOG = Logger.getLogger(TestUtil.class.getName());

    public static TestSuite getTestSuite(Request request, Response response) throws TestException {
        String script = request.getTestScript();
        if (StringUtil.isStrEmpty((String)script)) {
            return null;
        }
        try {
            GroovyClassLoader gcl = new GroovyClassLoader(TestUtil.class.getClassLoader());
            Class testClass = gcl.parseClass(script, "__GenRESTTestCase__");
            GroovyTestSuite suite = new GroovyTestSuite();
            RoRequestBean roRequest = new RoRequestBean(request);
            RoResponseBean roResponse = new RoResponseBean(response);
            Method[] m_arr = testClass.getDeclaredMethods();
            for (int i = 0; i < m_arr.length; ++i) {
                int modifiers = m_arr[i].getModifiers();
                Class<?> retType = m_arr[i].getReturnType();
                String methName = m_arr[i].getName();
                Class<?>[] p_arr = m_arr[i].getParameterTypes();
                if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || !retType.equals(Void.TYPE) || !methName.startsWith("test") || p_arr.length != 0) continue;
                RESTTestCase test = (RESTTestCase)GroovyTestSuite.createTest((Class)testClass, (String)methName);
                test.setRoRequestBean(roRequest);
                test.setRoResponseBean(roResponse);
                suite.addTest((Test)test);
            }
            return suite;
        }
        catch (CompilationFailedException ex) {
            throw new TestException("", ex);
        }
        catch (ClassCastException ex) {
            throw new TestException("", ex);
        }
    }

    private static final int getLineNumber(String str) {
        Pattern p = Pattern.compile("\\(__GenRESTTestCase__:([0-9]+)\\)");
        Matcher m = p.matcher(str);
        if (m.find()) {
            String lineNumberStr = m.group(1);
            return Integer.parseInt(lineNumberStr);
        }
        return 0;
    }

    public static TestResult execute(TestSuite suite) {
        TestFailureResultBean t;
        ArrayList<TestFailureResult> l;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TestRunner runner = new TestRunner(new PrintStream(baos));
        junit.framework.TestResult result = runner.doRun((Test)suite);
        TestResultBean resultBean = new TestResultBean();
        int runCount = result.runCount();
        int failureCount = result.failureCount();
        int errorCount = result.errorCount();
        resultBean.setRunCount(runCount);
        resultBean.setFailureCount(failureCount);
        resultBean.setErrorCount(errorCount);
        if (failureCount > 0) {
            l = new ArrayList<TestFailureResult>();
            Enumeration failures = result.failures();
            while (failures.hasMoreElements()) {
                TestFailure failure = (TestFailure)failures.nextElement();
                t = new TestFailureResultBean();
                t.setExceptionMessage(failure.exceptionMessage());
                t.setLineNumber(TestUtil.getLineNumber(failure.trace()));
                l.add(t);
            }
            resultBean.setFailures(l);
        }
        if (errorCount > 0) {
            l = new ArrayList();
            Enumeration errors = result.errors();
            while (errors.hasMoreElements()) {
                TestFailure error = (TestFailure)errors.nextElement();
                t = new TestFailureResultBean();
                t.setExceptionMessage(error.exceptionMessage());
                t.setLineNumber(TestUtil.getLineNumber(error.trace()));
                l.add(t);
            }
            resultBean.setErrors(l);
        }
        byte[] bresult = baos.toByteArray();
        resultBean.setMessage(new String(bresult));
        return resultBean;
    }
}

