/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.wiztools.commons.MultiValueMap;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.Base64;
import org.wiztools.restclient.HTTPAuthMethod;
import org.wiztools.restclient.HTTPMethod;
import org.wiztools.restclient.HTTPVersion;
import org.wiztools.restclient.ReqEntity;
import org.wiztools.restclient.ReqEntityBean;
import org.wiztools.restclient.Request;
import org.wiztools.restclient.RequestBean;
import org.wiztools.restclient.Response;
import org.wiztools.restclient.ResponseBean;
import org.wiztools.restclient.SSLHostnameVerifier;
import org.wiztools.restclient.TestFailureResult;
import org.wiztools.restclient.TestResult;
import org.wiztools.restclient.TestResultBean;
import org.wiztools.restclient.XMLException;

public final class XMLUtil {
    private static final Logger LOG = Logger.getLogger(XMLUtil.class.getName());
    private static final String[] VERSIONS = new String[]{"2.0", "2.1", "2.2a1", "2.2a2", "2.2", "2.3b1", "2.3", "2.3.1", "2.3.2", "2.3.3"};
    public static final String XML_MIME = "application/xml";

    private XMLUtil() {
    }

    private static void checkIfVersionValid(String restVersion) throws XMLException {
        if (restVersion == null) {
            throw new XMLException("Attribute `version' not available for root element <rest-client>");
        }
        int res = Arrays.binarySearch(VERSIONS, restVersion);
        if (res == -1) {
            throw new XMLException("Version not supported");
        }
    }

    private static Document request2XML(Request bean) throws XMLException {
        try {
            String testScript;
            ReqEntity rBean;
            MultiValueMap<String, String> headers;
            String sslTruststore;
            Element reqRootElement = new Element("rest-client");
            Attribute versionAttributes = new Attribute("version", "2.3.3");
            reqRootElement.addAttribute(versionAttributes);
            Element reqChildElement = new Element("request");
            Element reqChildSubElement = null;
            Element reqChildSubSubElement = null;
            reqChildSubElement = new Element("http-version");
            reqChildSubElement.appendChild(bean.getHttpVersion().versionNumber());
            reqChildElement.appendChild((Node)reqChildSubElement);
            reqChildSubElement = new Element("URL");
            reqChildSubElement.appendChild(bean.getUrl().toString());
            reqChildElement.appendChild((Node)reqChildSubElement);
            reqChildSubElement = new Element("method");
            reqChildSubElement.appendChild(bean.getMethod().name());
            reqChildElement.appendChild((Node)reqChildSubElement);
            List<HTTPAuthMethod> authMethods = bean.getAuthMethods();
            if (authMethods == null || authMethods.size() > 0) {
                String authUsername;
                String authRealm;
                reqChildSubElement = new Element("auth-methods");
                String methods = "";
                for (HTTPAuthMethod authMethod : authMethods) {
                    methods = methods + (Object)((Object)authMethod) + ",";
                }
                String authenticationMethod = methods.substring(0, methods.length() == 0 ? 0 : methods.length() - 1);
                reqChildSubElement.appendChild(authenticationMethod);
                reqChildElement.appendChild((Node)reqChildSubElement);
                boolean authPreemptive = bean.isAuthPreemptive();
                reqChildSubElement = new Element("auth-preemptive");
                reqChildSubElement.appendChild(new Boolean(authPreemptive).toString());
                reqChildElement.appendChild((Node)reqChildSubElement);
                String authHost = bean.getAuthHost();
                if (!StringUtil.isStrEmpty((String)authHost)) {
                    reqChildSubElement = new Element("auth-host");
                    reqChildSubElement.appendChild(authHost);
                    reqChildElement.appendChild((Node)reqChildSubElement);
                }
                if (!StringUtil.isStrEmpty((String)(authRealm = bean.getAuthRealm()))) {
                    reqChildSubElement = new Element("auth-realm");
                    reqChildSubElement.appendChild(authRealm);
                    reqChildElement.appendChild((Node)reqChildSubElement);
                }
                if (!StringUtil.isStrEmpty((String)(authUsername = bean.getAuthUsername()))) {
                    reqChildSubElement = new Element("auth-username");
                    reqChildSubElement.appendChild(authUsername);
                    reqChildElement.appendChild((Node)reqChildSubElement);
                }
                String authPassword = null;
                if (bean.getAuthPassword() != null && !StringUtil.isStrEmpty((String)(authPassword = new String(bean.getAuthPassword())))) {
                    String encPassword = Base64.encodeObject((Serializable)((Object)authPassword));
                    reqChildSubElement = new Element("auth-password");
                    reqChildSubElement.appendChild(encPassword);
                    reqChildElement.appendChild((Node)reqChildSubElement);
                }
            }
            if (!StringUtil.isStrEmpty((String)(sslTruststore = bean.getSslTrustStore()))) {
                reqChildSubElement = new Element("ssl-truststore");
                reqChildSubElement.appendChild(sslTruststore);
                reqChildElement.appendChild((Node)reqChildSubElement);
                String sslPassword = new String(bean.getSslTrustStorePassword());
                String encPassword = Base64.encodeObject((Serializable)((Object)sslPassword));
                reqChildSubElement = new Element("ssl-truststore-password");
                reqChildSubElement.appendChild(encPassword);
                reqChildElement.appendChild((Node)reqChildSubElement);
                String sslHostnameVerifier = bean.getSslHostNameVerifier().name();
                reqChildSubElement = new Element("ssl-hostname-verifier");
                reqChildSubElement.appendChild(sslHostnameVerifier);
                reqChildElement.appendChild((Node)reqChildSubElement);
            }
            if (!(headers = bean.getHeaders()).isEmpty()) {
                reqChildSubElement = new Element("headers");
                for (String key : headers.keySet()) {
                    for (String value : headers.get((Object)key)) {
                        reqChildSubSubElement = new Element("header");
                        reqChildSubSubElement.addAttribute(new Attribute("key", key));
                        reqChildSubSubElement.addAttribute(new Attribute("value", value));
                        reqChildSubElement.appendChild((Node)reqChildSubSubElement);
                    }
                }
                reqChildElement.appendChild((Node)reqChildSubElement);
            }
            if ((rBean = bean.getBody()) != null) {
                reqChildSubElement = new Element("body");
                String contentType = rBean.getContentType();
                String charSet = rBean.getCharSet();
                String body = rBean.getBody();
                reqChildSubElement.addAttribute(new Attribute("content-type", contentType));
                reqChildSubElement.addAttribute(new Attribute("charset", charSet));
                reqChildSubElement.appendChild(body);
                reqChildElement.appendChild((Node)reqChildSubElement);
            }
            if ((testScript = bean.getTestScript()) != null) {
                reqChildSubElement = new Element("test-script");
                reqChildSubElement.appendChild(testScript);
                reqChildElement.appendChild((Node)reqChildSubElement);
            }
            reqRootElement.appendChild((Node)reqChildElement);
            Document xomDocument = new Document(reqRootElement);
            return xomDocument;
        }
        catch (Exception ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    private static Map<String, String> getHeadersFromHeaderNode(Element node) throws XMLException {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (int i = 0; i < node.getChildElements().size(); ++i) {
            Element headerElement = node.getChildElements().get(i);
            if (!"header".equals(headerElement.getQualifiedName())) {
                throw new XMLException("<headers> element should contain only <header> elements");
            }
            m.put(headerElement.getAttributeValue("key"), headerElement.getAttributeValue("value"));
        }
        return m;
    }

    private static Request xml2Request(Document doc) throws MalformedURLException, XMLException {
        RequestBean requestBean = new RequestBean();
        Element rootNode = doc.getRootElement();
        if (!"rest-client".equals(rootNode.getQualifiedName())) {
            throw new XMLException("Root node is not <rest-client>");
        }
        XMLUtil.checkIfVersionValid(rootNode.getAttributeValue("version"));
        Element tNode = null;
        Element requestNode = null;
        if (rootNode.getChildElements().size() != 1) {
            throw new XMLException("There can be only one child node for root node: <request>");
        }
        if (rootNode.getFirstChildElement("request") == null) {
            throw new XMLException("The child node of <rest-client> should be <request>");
        }
        requestNode = rootNode.getFirstChildElement("request");
        for (int i = 0; i < requestNode.getChildElements().size(); ++i) {
            tNode = requestNode.getChildElements().get(i);
            String nodeName = tNode.getQualifiedName();
            if ("http-version".equals(nodeName)) {
                String t = tNode.getValue();
                HTTPVersion httpVersion = "1.1".equals(t) ? HTTPVersion.HTTP_1_1 : HTTPVersion.HTTP_1_0;
                requestBean.setHttpVersion(httpVersion);
                continue;
            }
            if ("URL".equals(nodeName)) {
                URL url = new URL(tNode.getValue());
                requestBean.setUrl(url);
                continue;
            }
            if ("method".equals(nodeName)) {
                requestBean.setMethod(HTTPMethod.get(tNode.getValue()));
                continue;
            }
            if ("auth-methods".equals(nodeName)) {
                String[] authenticationMethods = tNode.getValue().split(",");
                for (int j = 0; j < authenticationMethods.length; ++j) {
                    requestBean.addAuthMethod(HTTPAuthMethod.get(authenticationMethods[j]));
                }
                continue;
            }
            if ("auth-preemptive".equals(nodeName)) {
                if (tNode.getValue().equals("true")) {
                    requestBean.setAuthPreemptive(true);
                    continue;
                }
                requestBean.setAuthPreemptive(false);
                continue;
            }
            if ("auth-host".equals(nodeName)) {
                requestBean.setAuthHost(tNode.getValue());
                continue;
            }
            if ("auth-realm".equals(nodeName)) {
                requestBean.setAuthRealm(tNode.getValue());
                continue;
            }
            if ("auth-username".equals(nodeName)) {
                requestBean.setAuthUsername(tNode.getValue());
                continue;
            }
            if ("auth-password".equals(nodeName)) {
                String password = (String)Base64.decodeToObject(tNode.getValue());
                requestBean.setAuthPassword(password.toCharArray());
                continue;
            }
            if ("ssl-truststore".equals(nodeName)) {
                String sslTrustStore = tNode.getValue();
                requestBean.setSslTrustStore(sslTrustStore);
                continue;
            }
            if ("ssl-truststore-password".equals(nodeName)) {
                String sslTrustStorePassword = (String)Base64.decodeToObject(tNode.getValue());
                requestBean.setSslTrustStorePassword(sslTrustStorePassword.toCharArray());
                continue;
            }
            if ("ssl-hostname-verifier".equals(nodeName)) {
                String sslHostnameVerifierStr = tNode.getValue();
                SSLHostnameVerifier sslHostnameVerifier = SSLHostnameVerifier.valueOf(sslHostnameVerifierStr);
                requestBean.setSslHostNameVerifier(sslHostnameVerifier);
                continue;
            }
            if ("headers".equals(nodeName)) {
                Map<String, String> m = XMLUtil.getHeadersFromHeaderNode(tNode);
                for (String key : m.keySet()) {
                    requestBean.addHeader(key, m.get(key));
                }
                continue;
            }
            if ("body".equals(nodeName)) {
                requestBean.setBody(new ReqEntityBean(tNode.getValue(), tNode.getAttributeValue("content-type"), tNode.getAttributeValue("charset")));
                continue;
            }
            if ("test-script".equals(nodeName)) {
                requestBean.setTestScript(tNode.getValue());
                continue;
            }
            throw new XMLException("Invalid element encountered: <" + nodeName + ">");
        }
        return requestBean;
    }

    private static Document response2XML(Response bean) throws XMLException {
        try {
            TestResult testResult;
            String responseBody;
            Element respRootElement = new Element("rest-client");
            Element respChildElement = new Element("response");
            Element respChildSubElement = null;
            Element respChildSubSubElement = null;
            Attribute versionAttributes = new Attribute("version", "2.3.3");
            respRootElement.addAttribute(versionAttributes);
            respChildSubElement = new Element("execution-time");
            respChildSubElement.appendChild(String.valueOf(bean.getExecutionTime()));
            respChildElement.appendChild((Node)respChildSubElement);
            respChildSubElement = new Element("status");
            Attribute codeAttributes = new Attribute("code", String.valueOf(bean.getStatusCode()));
            respChildSubElement.addAttribute(codeAttributes);
            respChildSubElement.appendChild(bean.getStatusLine());
            respChildElement.appendChild((Node)respChildSubElement);
            MultiValueMap<String, String> headers = bean.getHeaders();
            if (!headers.isEmpty()) {
                Attribute keyAttribute = null;
                Attribute valueAttribute = null;
                respChildSubElement = new Element("headers");
                for (String key : headers.keySet()) {
                    for (String value : headers.get((Object)key)) {
                        respChildSubSubElement = new Element("header");
                        keyAttribute = new Attribute("key", key);
                        valueAttribute = new Attribute("value", value);
                        respChildSubSubElement.addAttribute(keyAttribute);
                        respChildSubSubElement.addAttribute(valueAttribute);
                        respChildSubElement.appendChild((Node)respChildSubSubElement);
                    }
                }
                respChildElement.appendChild((Node)respChildSubElement);
            }
            if ((responseBody = bean.getResponseBody()) != null) {
                respChildSubElement = new Element("body");
                respChildSubElement.appendChild(responseBody);
                respChildElement.appendChild((Node)respChildSubElement);
            }
            if ((testResult = bean.getTestResult()) != null) {
                Element e_line;
                Element e_message;
                List<TestFailureResult> l;
                respChildSubElement = new Element("test-result");
                Element e_runCount = new Element("run-coun");
                e_runCount.appendChild(String.valueOf(testResult.getRunCount()));
                Element e_failureCount = new Element("failure-coun");
                e_failureCount.appendChild(String.valueOf(testResult.getFailureCount()));
                Element e_errorCount = new Element("error-coun");
                e_errorCount.appendChild(String.valueOf(testResult.getErrorCount()));
                respChildSubElement.appendChild((Node)e_runCount);
                respChildSubElement.appendChild((Node)e_failureCount);
                respChildSubElement.appendChild((Node)e_errorCount);
                if (testResult.getFailureCount() > 0) {
                    Element e_failures = new Element("failures");
                    l = testResult.getFailures();
                    for (TestFailureResult b : l) {
                        e_message = new Element("message");
                        e_message.appendChild(b.getExceptionMessage());
                        e_line = new Element("line-number");
                        e_line.appendChild(String.valueOf(b.getLineNumber()));
                        Element e_failure = new Element("failure");
                        e_failure.appendChild((Node)e_message);
                        e_failure.appendChild((Node)e_line);
                        e_failures.appendChild((Node)e_failure);
                    }
                    respChildSubElement.appendChild((Node)e_failures);
                }
                if (testResult.getFailureCount() > 0) {
                    Element e_errors = new Element("errors");
                    l = testResult.getErrors();
                    for (TestFailureResult b : l) {
                        e_message = new Element("message");
                        e_message.appendChild(b.getExceptionMessage());
                        e_line = new Element("line-number");
                        e_line.appendChild(String.valueOf(b.getLineNumber()));
                        Element e_error = new Element("error");
                        e_error.appendChild((Node)e_message);
                        e_error.appendChild((Node)e_line);
                        e_errors.appendChild((Node)e_error);
                    }
                    respChildSubElement.appendChild((Node)e_errors);
                }
                Element e_trace = new Element("trace");
                e_trace.appendChild(testResult.toString());
                respChildSubElement.appendChild((Node)e_trace);
                respChildElement.appendChild((Node)respChildSubElement);
            }
            respRootElement.appendChild((Node)respChildElement);
            Document xomDocument = new Document(respRootElement);
            return xomDocument;
        }
        catch (Exception ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    private static Response xml2Response(Document doc) throws XMLException {
        ResponseBean responseBean = new ResponseBean();
        Element rootNode = doc.getRootElement();
        if (!"rest-client".equals(rootNode.getQualifiedName())) {
            throw new XMLException("Root node is not <rest-client>");
        }
        XMLUtil.checkIfVersionValid(rootNode.getAttributeValue("version"));
        Element tNode = null;
        Element responseNode = null;
        if (rootNode.getChildElements().size() != 1) {
            throw new XMLException("There can be only one child node for root node: <response>");
        }
        if (rootNode.getFirstChildElement("response") == null) {
            throw new XMLException("The child node of <rest-client> should be <response>");
        }
        responseNode = rootNode.getFirstChildElement("response");
        for (int i = 0; i < responseNode.getChildElements().size(); ++i) {
            tNode = responseNode.getChildElements().get(i);
            String nodeName = tNode.getQualifiedName();
            if ("execution-time".equals(nodeName)) {
                responseBean.setExecutionTime(Long.parseLong(tNode.getValue()));
                continue;
            }
            if ("status".equals(nodeName)) {
                responseBean.setStatusLine(tNode.getValue());
                responseBean.setStatusCode(Integer.parseInt(tNode.getAttributeValue("code")));
                continue;
            }
            if ("headers".equals(nodeName)) {
                Map<String, String> m = XMLUtil.getHeadersFromHeaderNode(tNode);
                for (String key : m.keySet()) {
                    responseBean.addHeader(key, m.get(key));
                }
                continue;
            }
            if ("body".equals(nodeName)) {
                responseBean.setResponseBody(tNode.getValue());
                continue;
            }
            if ("test-result".equals(nodeName)) {
                TestResultBean testResultBean = new TestResultBean();
                for (int j = 0; j < tNode.getChildCount(); ++j) {
                    String nn = tNode.getQualifiedName();
                    if ("run-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("failure-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("error-count".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if ("failures".equals(nn)) {
                        throw new XMLException("<headers> element should contain only <header> elements");
                    }
                    if (!"errors".equals(nn)) continue;
                    throw new XMLException("<headers> element should contain only <header> elements");
                }
                responseBean.setTestResult(testResultBean);
                continue;
            }
            throw new XMLException("Unrecognized element found: <" + nodeName + ">");
        }
        return responseBean;
    }

    private static void writeXML(Document doc, File f) throws IOException, XMLException {
        try {
            OutputStream out = new FileOutputStream(f);
            out = new BufferedOutputStream(out);
            Serializer serializer = new Serializer(out, XMLUtil.getDocumentCharset(f));
            serializer.write(doc);
            out.close();
        }
        catch (IOException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    private static Document getDocumentFromFile(File f) throws IOException, XMLException {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(f);
            return doc;
        }
        catch (ParsingException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
    }

    public static String getDocumentCharset(File f) throws IOException, XMLException {
        XMLEventReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            reader = inputFactory.createXMLEventReader(new FileInputStream(f));
            XMLEvent event = reader.nextEvent();
            StartDocument document = (StartDocument)event;
            String string = document.getCharacterEncodingScheme();
            return string;
        }
        catch (XMLStreamException ex) {
            throw new XMLException(ex.getMessage(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException ex) {
                    LOG.warning(ex.getMessage());
                }
            }
        }
    }

    public static void writeRequestXML(Request bean, File f) throws IOException, XMLException {
        Document doc = XMLUtil.request2XML(bean);
        XMLUtil.writeXML(doc, f);
    }

    public static void writeResponseXML(Response bean, File f) throws IOException, XMLException {
        Document doc = XMLUtil.response2XML(bean);
        XMLUtil.writeXML(doc, f);
    }

    public static Request getRequestFromXMLFile(File f) throws IOException, XMLException {
        Document doc = XMLUtil.getDocumentFromFile(f);
        return XMLUtil.xml2Request(doc);
    }

    public static Response getResponseFromXMLFile(File f) throws IOException, XMLException {
        Document doc = XMLUtil.getDocumentFromFile(f);
        return XMLUtil.xml2Response(doc);
    }

    public static String indentXML(String in) throws XMLException, IOException {
        try {
            Builder parser = new Builder();
            Document doc = parser.build(in, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)baos);
            serializer.setIndent(4);
            serializer.setMaxLength(69);
            serializer.write(doc);
            return new String(baos.toByteArray());
        }
        catch (ParsingException ex) {
            throw new XMLException("XML indentation failed.", ex);
        }
    }

    static {
        Arrays.sort(VERSIONS);
    }
}

