/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedEventException;

public class EventConverterUtils {
    private static Log log = LogFactory.getLog(EventConverterUtils.class);
    private static Gson gson = new Gson();

    public static List<Event> convertFromJson(String json) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        try {
            JSONArray eventObjects = new JSONArray(json);
            for (int i = 0; i < eventObjects.length(); ++i) {
                Event event = (Event)gson.fromJson(eventObjects.get(i).toString(), Event.class);
                if (event.getStreamId() == null || event.getStreamId().equals("")) {
                    String errorMsg = "Stream Id cannot be null or empty, for JSON : " + eventObjects.get(i).toString();
                    MalformedEventException malformedEventException = new MalformedEventException();
                    if (log.isDebugEnabled()) {
                        log.error((Object)errorMsg, (Throwable)malformedEventException);
                    } else {
                        log.error((Object)errorMsg);
                    }
                    throw malformedEventException;
                }
                eventList.add(event);
            }
        }
        catch (JSONException e) {
            String errorMsg = "Error converting JSON to event, for JSON : " + json;
            MalformedEventException malformedEventException = new MalformedEventException(errorMsg, e);
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        return eventList;
    }

    public static List<Event> convertFromJson(String json, String streamId) {
        if (streamId == null || streamId.equals("")) {
            String errorMsg = "Stream name cannot be null or empty";
            MalformedEventException malformedEventException = new MalformedEventException();
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        ArrayList<Event> eventList = new ArrayList<Event>();
        try {
            JSONArray eventObjects = new JSONArray(json);
            for (int i = 0; i < eventObjects.length(); ++i) {
                Event event = (Event)gson.fromJson(eventObjects.get(i).toString(), Event.class);
                event.setStreamId(streamId);
                eventList.add(event);
            }
        }
        catch (JSONException e) {
            String errorMsg = "Error converting JSON to event, for JSON : " + json;
            MalformedEventException malformedEventException = new MalformedEventException(errorMsg, e);
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        return eventList;
    }

    public static List<Event> convertFromJson(String json, String streamId, StreamDefinition streamDefinition) {
        if (streamId == null || streamId.equals("")) {
            String errorMsg = "Stream name cannot be null or empty";
            MalformedEventException malformedEventException = new MalformedEventException();
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        ArrayList<Event> eventList = new ArrayList<Event>();
        try {
            JsonParser jsonParser = new JsonParser();
            JSONArray eventObjects = new JSONArray(json);
            for (int i = 0; i < eventObjects.length(); ++i) {
                Event event = new Event();
                JsonElement jsonElement = jsonParser.parse(eventObjects.get(i).toString());
                JsonObject jsonObject = (JsonObject)jsonElement;
                Set entries = jsonObject.entrySet();
                for (Map.Entry entry : entries) {
                    List<Attribute> attributeList;
                    String key = (String)entry.getKey();
                    if (!(entry.getValue() instanceof JsonArray) || (attributeList = streamDefinition.getAttributeListForKey(key)) == null) continue;
                    JsonArray jsonArray = (JsonArray)entry.getValue();
                    Iterator it = jsonArray.iterator();
                    ArrayList<Object> list = new ArrayList<Object>();
                    int pos = 0;
                    while (it.hasNext()) {
                        Object value = EventConverterUtils.getValue(jsonParser.parse(it.next().toString()).getAsString(), attributeList.get(pos).getType());
                        list.add(value);
                        ++pos;
                    }
                    event.setData(key, list.toArray());
                }
                event.setStreamId(streamId);
                eventList.add(event);
            }
        }
        catch (JSONException e) {
            String errorMsg = "Error converting JSON to event, for JSON : " + json;
            MalformedEventException malformedEventException = new MalformedEventException(errorMsg, e);
            if (log.isDebugEnabled()) {
                log.error((Object)errorMsg, (Throwable)malformedEventException);
            } else {
                log.error((Object)errorMsg);
            }
            throw malformedEventException;
        }
        return eventList;
    }

    public static Object getValue(String val, AttributeType attributeType) {
        switch (attributeType) {
            case BOOL: {
                return Boolean.parseBoolean(val);
            }
            case INT: {
                return Integer.parseInt(val);
            }
            case DOUBLE: {
                return Double.parseDouble(val);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(val));
            }
            case LONG: {
                return Long.parseLong(val);
            }
            case STRING: {
                return val;
            }
        }
        return "";
    }
}

