/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.frameworkutils.enums.OperatingSystems;

public class ExtensionUtils {
    public static final String SYSTEM_ARTIFACT_RESOURCE_LOCATION = "framework.resource.location";
    private static final Log log = LogFactory.getLog(ExtensionUtils.class);

    public static String getSystemResourceLocation() {
        String resourceLocation = System.getProperty("os.name").toLowerCase().contains(OperatingSystems.WINDOWS.name()) ? System.getProperty(SYSTEM_ARTIFACT_RESOURCE_LOCATION).replace("/", "\\") : System.getProperty(SYSTEM_ARTIFACT_RESOURCE_LOCATION).replace("/", "/");
        return resourceLocation;
    }

    public static String getSystemSettingsLocation() {
        String settingsLocation = System.getProperty("automation.settings.location") != null ? (System.getProperty("os.name").toLowerCase().contains(OperatingSystems.WINDOWS.name()) ? System.getProperty("automation.settings.location").replace("/", "\\") : System.getProperty("automation.settings.location").replace("/", "/")) : ExtensionUtils.getSystemResourceLocation();
        return settingsLocation;
    }

    public static String getReportLocation() {
        String reportLocation = System.getProperty("basedir", ".") + File.separator + "target";
        return reportLocation;
    }

    public static String getCarbonZipLocation() {
        return System.getProperty("carbon.zip");
    }

    public static String getCarbonTempLocation() {
        String extractDir = "carbontmp" + System.currentTimeMillis();
        String baseDir = System.getProperty("basedir", ".") + File.separator + "target";
        return new File(baseDir).getAbsolutePath() + File.separator + extractDir;
    }

    public static String getCarbonServerAxisServiceDirectory() {
        return ExtensionUtils.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "axis2services";
    }

    public static String getCarbonServerLibLocation() {
        return ExtensionUtils.getCarbonHome() + File.separator + "repository" + File.separator + "components" + File.separator + "lib";
    }

    public static String getCarbonServerConfLocation() {
        return ExtensionUtils.getCarbonHome() + File.separator + "repository" + File.separator + "conf";
    }

    public static String getCarbonHome() {
        if (System.getProperty("user.dir") != null) {
            return System.getProperty("user.dir");
        }
        log.error((Object)"Cannot read carbon.home property ");
        return null;
    }
}

