/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.jmsserver.client;

import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;

public class JMSQueueMessageProducer {
    private Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private QueueConnectionFactory connectionFactory = null;

    public JMSQueueMessageProducer(JMSBrokerConfiguration brokerConfiguration) throws NamingException {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", brokerConfiguration.getInitialNamingFactory());
        if (brokerConfiguration.getProviderURL().startsWith("amqp://")) {
            props.put("connectionfactory.QueueConnectionFactory", brokerConfiguration.getProviderURL());
        } else {
            props.setProperty("java.naming.provider.url", brokerConfiguration.getProviderURL());
        }
        InitialContext ctx = new InitialContext(props);
        this.connectionFactory = (QueueConnectionFactory)ctx.lookup("QueueConnectionFactory");
    }

    public void connect(String queueName) throws JMSException, NamingException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        Queue destination = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)destination);
        this.producer.setDeliveryMode(1);
    }

    public void connect(String queueName, boolean persistMessage) throws JMSException {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        Queue destination = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)destination);
        if (persistMessage) {
            this.producer.setDeliveryMode(2);
        } else {
            this.producer.setDeliveryMode(1);
        }
    }

    public void disconnect() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void pushMessage(String messageContent) throws AutomationFrameworkException {
        if (this.producer == null) {
            throw new AutomationFrameworkException("No Connection with Queue. Please connect");
        }
        TextMessage message = null;
        try {
            message = this.session.createTextMessage(messageContent);
            this.producer.send((Message)message);
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("Message creation failed", (Throwable)e);
        }
    }

    public void sendBytesMessage(byte[] payload) throws AutomationFrameworkException {
        BytesMessage bm = null;
        try {
            bm = this.session.createBytesMessage();
            bm.writeBytes(payload);
            this.producer.send((Message)bm);
        }
        catch (JMSException e) {
            throw new AutomationFrameworkException("Byte message creation failed", (Throwable)e);
        }
    }
}

