/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerLogReader
implements Runnable {
    private String streamType;
    private InputStream inputStream;
    private StringBuilder stringBuilder;
    private static final String STREAM_TYPE_IN = "inputStream";
    private static final String STREAM_TYPE_ERROR = "errorStream";
    private final Object lock = new Object();
    private Thread thread;
    private volatile boolean running = true;
    private static final Log log = LogFactory.getLog(ServerLogReader.class);

    public ServerLogReader(String name, InputStream is) {
        this.streamType = name;
        this.inputStream = is;
        this.stringBuilder = new StringBuilder();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.inputStream, Charset.defaultCharset());
            bufferedReader = new BufferedReader(inputStreamReader);
            while (this.running) {
                if (!bufferedReader.ready()) continue;
                String s = bufferedReader.readLine();
                this.stringBuilder.setLength(0);
                if (s == null) {
                    break;
                }
                if (STREAM_TYPE_IN.equals(this.streamType)) {
                    this.stringBuilder.append(s).append("\n");
                    log.info((Object)s);
                    continue;
                }
                if (!STREAM_TYPE_ERROR.equals(this.streamType)) continue;
                this.stringBuilder.append(s).append("\n");
                log.error((Object)s);
            }
        }
        catch (Exception ex) {
            log.error((Object)("Problem reading the [" + this.streamType + "] due to: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    this.inputStream.close();
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred while closing the server log stream: " + e.getMessage()), (Throwable)e);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error occurred while closing the server log stream: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutput() {
        Object object = this.lock;
        synchronized (object) {
            return this.stringBuilder.toString();
        }
    }
}

