/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.extensions.servers.webserver;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleWebServer
extends Thread {
    private volatile boolean running = true;
    private int port;
    private int expectedResponseCode;
    protected Log log = LogFactory.getLog(SimpleWebServer.class);

    public SimpleWebServer(int listenPort, int expectedResponseCode) {
        this.port = listenPort;
        this.expectedResponseCode = expectedResponseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket serverSocket = null;
        Socket connectionSocket = null;
        try {
            this.log.info((Object)("Trying to bind to localhost on port " + Integer.toString(this.port) + "..."));
            serverSocket = new ServerSocket(this.port);
            this.log.info((Object)"Running Simple WebServer!\n");
            connectionSocket = serverSocket.accept();
            connectionSocket.setSoTimeout(30000);
            while (this.running) {
                this.log.info((Object)"\nReady, Waiting for requests...\n");
                try {
                    if (connectionSocket.isClosed()) continue;
                    InetAddress client = connectionSocket.getInetAddress();
                    this.log.info((Object)(client.getHostName() + " connected to server.\n"));
                    BufferedReader input = new BufferedReader(new InputStreamReader(connectionSocket.getInputStream(), Charset.defaultCharset()));
                    if (!input.ready()) continue;
                    DataOutputStream output = new DataOutputStream(connectionSocket.getOutputStream());
                    this.httpHandler(input, output);
                }
                catch (Exception e) {
                    this.log.info((Object)("\nError:" + e.getMessage()));
                    this.running = false;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("\nFatal Error:" + e.getMessage()));
            this.running = false;
        }
        finally {
            try {
                if (connectionSocket != null) {
                    connectionSocket.close();
                    serverSocket.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Error while shutting down server sockets", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void httpHandler(BufferedReader input, DataOutputStream output) throws IOException, InterruptedException {
        try {
            String tmp = input.readLine();
            String contentType = input.readLine();
            this.log.info((Object)tmp);
            assert (tmp != null);
            String sampleReturnResponse = "<testResponse>\n   <message>" + tmp.toUpperCase() + "Success</message>\n" + " </testResponse>";
            output.writeBytes(this.constructHttpHeader(this.expectedResponseCode, contentType));
            output.write(sampleReturnResponse.getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            this.log.error((Object)("error" + e.getMessage()));
        }
        finally {
            output.flush();
            Thread.sleep(1000L);
            input.close();
            output.close();
        }
    }

    private String constructHttpHeader(int returnCode, String contentType) {
        String header = "HTTP/1.0 ";
        switch (returnCode) {
            case 200: {
                header = header + "200 OK";
                break;
            }
            case 400: {
                header = header + "400 Bad Request";
                break;
            }
            case 403: {
                header = header + "403 Forbidden";
                break;
            }
            case 404: {
                header = header + "404 Not Found";
                break;
            }
            case 500: {
                header = header + "500 Internal Server Error";
                break;
            }
            case 501: {
                header = header + "501 Not Implemented";
                break;
            }
            case 503: {
                header = header + "503 Error";
                break;
            }
            default: {
                header = header + returnCode + " Testing response code";
            }
        }
        header = header + "\r\n";
        header = header + "Connection: close\r\n";
        header = header + "Server: SimpleWebServer\r\n";
        header = header + contentType + "\r\n";
        header = header + "\r\n";
        return header;
    }

    public void terminate() throws IOException {
        this.running = false;
    }
}

