/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.persistence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.transport.passthru.core.ssl.SSLConfiguration;
import org.wso2.carbon.inbound.endpoint.persistence.InboundEndpointInfoDTO;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;

public class InboundEndpointsDataStore {
    private static final Log log = LogFactory.getLog(InboundEndpointsDataStore.class);
    private static InboundEndpointsDataStore instance = new InboundEndpointsDataStore();
    private Map<Integer, List<InboundEndpointInfoDTO>> endpointListeningInfo = new ConcurrentHashMap<Integer, List<InboundEndpointInfoDTO>>();
    private Map<String, Set<String>> endpointPollingInfo = new ConcurrentHashMap<String, Set<String>>();

    private InboundEndpointsDataStore() {
    }

    public static InboundEndpointsDataStore getInstance() {
        return instance;
    }

    public void registerListeningEndpoint(int port, String tenantDomain, String protocol, String name, InboundProcessorParams params) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port -= PersistenceUtils.getPortOffset(params.getProperties()));
        if (tenantList == null) {
            tenantList = new ArrayList<InboundEndpointInfoDTO>();
            this.endpointListeningInfo.put(port, tenantList);
        }
        tenantList.add(new InboundEndpointInfoDTO(tenantDomain, protocol, name, params));
    }

    public void registerPollingingEndpoint(String tenantDomain, String name) {
        Set<String> lNames = this.endpointPollingInfo.get(tenantDomain);
        if (lNames == null) {
            lNames = new HashSet<String>();
        }
        lNames.add(name);
        this.endpointPollingInfo.put(tenantDomain, lNames);
    }

    public void registerSSLListeningEndpoint(int port, String tenantDomain, String protocol, String name, SSLConfiguration sslConfiguration, InboundProcessorParams params) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port -= PersistenceUtils.getPortOffset(params.getProperties()));
        if (tenantList == null) {
            tenantList = new ArrayList<InboundEndpointInfoDTO>();
            this.endpointListeningInfo.put(port, tenantList);
        }
        InboundEndpointInfoDTO inboundEndpointInfoDTO = new InboundEndpointInfoDTO(tenantDomain, protocol, name, params);
        inboundEndpointInfoDTO.setSslConfiguration(sslConfiguration);
        tenantList.add(inboundEndpointInfoDTO);
    }

    public String getListeningEndpointName(int port, String tenantDomain) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port);
        if (tenantList != null) {
            for (InboundEndpointInfoDTO tenantInfo : tenantList) {
                if (!tenantInfo.getTenantDomain().equals(tenantDomain)) continue;
                return tenantInfo.getEndpointName();
            }
        }
        return null;
    }

    public void unregisterListeningEndpoint(int port, String tenantDomain) {
        List<InboundEndpointInfoDTO> tenantList = this.endpointListeningInfo.get(port);
        if (tenantList != null) {
            for (InboundEndpointInfoDTO tenantInfo : tenantList) {
                if (!tenantInfo.getTenantDomain().equals(tenantDomain)) continue;
                tenantList.remove(tenantInfo);
                break;
            }
        }
        if (this.endpointListeningInfo.get(port) != null && this.endpointListeningInfo.get(port).size() == 0) {
            this.endpointListeningInfo.remove(port);
        }
    }

    public void unregisterPollingEndpoint(String tenantDomain, String name) {
        Set<String> lNames = this.endpointPollingInfo.get(tenantDomain);
        if (lNames != null && !lNames.isEmpty()) {
            for (String strName : lNames) {
                if (!strName.equals(name)) continue;
                lNames.remove(strName);
                break;
            }
            if (lNames.isEmpty()) {
                this.endpointPollingInfo.remove(tenantDomain);
            }
        }
    }

    public boolean isPollingEndpointRegistered(String tenantDomain, String name) {
        Set<String> lNames = this.endpointPollingInfo.get(tenantDomain);
        if (lNames != null && !lNames.isEmpty()) {
            for (String strName : lNames) {
                if (!strName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEndpointRegistryEmpty(int port) {
        return this.endpointListeningInfo.get(port) == null;
    }

    public Map<Integer, List<InboundEndpointInfoDTO>> getAllListeningEndpointData() {
        return this.endpointListeningInfo;
    }

    public Map<String, Set<String>> getAllPollingingEndpointData() {
        return this.endpointPollingInfo;
    }
}

