/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.generic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.base.SequenceMediator;

public abstract class GenericPollingConsumer {
    protected Properties properties;
    protected String name;
    protected SynapseEnvironment synapseEnvironment;
    protected long scanInterval;
    protected String injectingSeq;
    protected String onErrorSeq;
    protected boolean coordination;
    protected boolean sequential;
    private static final Log log = LogFactory.getLog(GenericPollingConsumer.class);

    public GenericPollingConsumer(Properties properties, String name, SynapseEnvironment synapseEnvironment, long scanInterval, String injectingSeq, String onErrorSeq, boolean coordination, boolean sequential) {
        this.properties = properties;
        this.name = name;
        this.synapseEnvironment = synapseEnvironment;
        this.scanInterval = scanInterval;
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.coordination = coordination;
        this.sequential = sequential;
    }

    public abstract Object poll();

    public void destroy() {
        log.info((Object)"Default destroy invoked. Not overwritten.");
    }

    protected boolean injectMessage(String strMessage, String contentType) {
        AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(strMessage.getBytes()));
        return this.injectMessage((InputStream)in, contentType);
    }

    protected boolean injectMessage(InputStream in, String contentType) {
        try {
            SOAPBuilder builder;
            org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processed Custom inbound EP Message of Content-type : " + contentType));
            }
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            msgCtx.setProperty("inbound.endpoint.name", (Object)this.name);
            if (contentType == null) {
                log.debug((Object)"No content type specified. Using SOAP builder.");
                builder = new SOAPBuilder();
            } else {
                int index = contentType.indexOf(59);
                String type = index > 0 ? contentType.substring(0, index) : contentType;
                builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
                if (builder == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                    }
                    builder = new SOAPBuilder();
                }
            }
            OMElement documentElement = builder.processDocument(in, contentType, axis2MsgCtx);
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
            if (this.injectingSeq == null || this.injectingSeq.equals("")) {
                log.error((Object)("Sequence name not specified. Sequence : " + this.injectingSeq));
                return false;
            }
            SequenceMediator seq = (SequenceMediator)this.synapseEnvironment.getSynapseConfiguration().getSequence(this.injectingSeq);
            if (seq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("injecting message to sequence : " + this.injectingSeq));
                }
                seq.setErrorHandler(this.onErrorSeq);
                if (!seq.isInitialized()) {
                    seq.init(this.synapseEnvironment);
                }
                if (!this.synapseEnvironment.injectInbound(msgCtx, seq, this.sequential)) {
                    return false;
                }
            } else {
                log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while processing the Custom Inbound EP Message.");
        }
        return true;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UUIDGenerator.getUUID());
        return msgCtx;
    }

    protected Properties getInboundProperties() {
        return this.properties;
    }
}

