/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.mqtt;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttAsyncCallback;

public class MqttClientManager {
    private static MqttClientManager instance;
    private static final Log log;
    private ConcurrentHashMap<String, MqttAsyncClient> mqttClientMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MqttAsyncCallback> mqttCallbackMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Boolean> tenantLoadingFlagMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> inboundNameToIdentifierMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MqttDefaultFilePersistence> mqttClientDataStoreMap = new ConcurrentHashMap();

    private MqttClientManager() {
    }

    public static synchronized MqttClientManager getInstance() {
        if (instance == null) {
            log.info((Object)"Initializing.. MQTT Client Manager");
            instance = new MqttClientManager();
        }
        return instance;
    }

    public void registerMqttClient(String identifier, MqttAsyncClient mqttClient) {
        this.mqttClientMap.put(identifier, mqttClient);
    }

    public void unregisterMqttClient(String identifier, String name) {
        this.mqttClientMap.remove(identifier);
        this.mqttCallbackMap.remove(identifier);
        this.tenantLoadingFlagMap.remove(identifier);
        this.inboundNameToIdentifierMap.remove(name);
        this.mqttClientDataStoreMap.remove(identifier);
    }

    public boolean hasMqttClient(String identifier) {
        return this.mqttClientMap.containsKey(identifier);
    }

    public MqttAsyncClient getMqttClient(String identifier) {
        if (this.tenantLoadingFlagMap.containsKey(identifier)) {
            return this.mqttClientMap.get(identifier);
        }
        MqttAsyncCallback callback = this.mqttCallbackMap.get(identifier);
        String msg = "Client ID: " + callback.getMqttConnectionConsumer().getMqttAsyncClient().getClientId() + " Server Host: " + callback.getMqttConnectionConsumer().getMqttConnectionFactory().getServerHost() + " Server Port: " + callback.getMqttConnectionConsumer().getMqttConnectionFactory().getServerPort() + " is bound to existing MQTT Inbound Endpoint.";
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public void registerMqttCallback(String identifier, MqttAsyncCallback mqttCallback) {
        this.mqttCallbackMap.put(identifier, mqttCallback);
    }

    public boolean hasMqttCallback(String identifier) {
        return this.mqttCallbackMap.containsKey(identifier);
    }

    public MqttAsyncCallback getMqttCallback(String identifier) {
        return this.mqttCallbackMap.get(identifier);
    }

    public void registerInboundTenantLoadingFlag(String identifier) {
        this.tenantLoadingFlagMap.put(identifier, true);
    }

    public void unRegisterInboundTenantLoadingFlag(String identifier) {
        this.tenantLoadingFlagMap.remove(identifier);
    }

    public boolean isInboundTenantLoadingFlagSet(String identifier) {
        return this.tenantLoadingFlagMap.containsKey(identifier);
    }

    public String buildIdentifier(String clientId, String host, String port) {
        return clientId + "." + host + "." + port;
    }

    public void registerInboundEndpoint(String name, String identifier) {
        this.inboundNameToIdentifierMap.put(name, identifier);
    }

    public String getInboundEndpointIdentifier(String name) {
        return this.inboundNameToIdentifierMap.get(name);
    }

    public boolean hasInboundEndpoint(String name) {
        return this.inboundNameToIdentifierMap.containsKey(name);
    }

    public String buildNameIdentifier(String name, String tenantId) {
        return name + "." + tenantId;
    }

    public void registerClientDataStore(String identifier, MqttDefaultFilePersistence dataStore) {
        this.mqttClientDataStoreMap.put(identifier, dataStore);
    }

    public boolean hasClientDataStore(String identifier) {
        return this.mqttClientDataStoreMap.containsKey(identifier);
    }

    public MqttDefaultFilePersistence getMqttClientDataStore(String identifier) {
        return this.mqttClientDataStoreMap.get(identifier);
    }

    static {
        log = LogFactory.getLog(MqttClientManager.class);
    }
}

