/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

public class InboundWebsocketConfiguration {
    private final int port;
    private final String name;
    private String bossThreadPoolSize;
    private String workerThreadPoolSize;
    private int broadcastLevel;
    private String outFlowDispatchSequence;
    private String outFlowErrorSequence;
    private String subprotocolHandler;
    private String defaultContentType;
    private String pipelineHandler;
    private String dispatchToCustomSequence;
    private final boolean usePortOffset;
    private int inflowIdleTime;
    private int outflowIdleTime;

    private InboundWebsocketConfiguration(InboundWebsocketConfigurationBuilder builder) {
        this.port = builder.port;
        this.name = builder.name;
        this.bossThreadPoolSize = builder.bossThreadPoolSize;
        this.workerThreadPoolSize = builder.workerThreadPoolSize;
        this.broadcastLevel = builder.broadcastLevel;
        this.outFlowDispatchSequence = builder.outFlowDispatchSequence;
        this.outFlowErrorSequence = builder.outFlowErrorSequence;
        this.subprotocolHandler = builder.subprotocolHandler;
        this.defaultContentType = builder.defaultContentType;
        this.pipelineHandler = builder.pipelineHandler;
        this.dispatchToCustomSequence = builder.dispatchToCustomSequence;
        this.usePortOffset = builder.usePortOffset;
        this.inflowIdleTime = builder.inflowIdleTime;
        this.outflowIdleTime = builder.outflowIdleTime;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.getName();
    }

    public String getBossThreadPoolSize() {
        return this.bossThreadPoolSize;
    }

    public String getWorkerThreadPoolSize() {
        return this.workerThreadPoolSize;
    }

    public int getBroadcastLevel() {
        return this.broadcastLevel;
    }

    public String getOutFlowDispatchSequence() {
        return this.outFlowDispatchSequence;
    }

    public String getOutFlowErrorSequence() {
        return this.outFlowErrorSequence;
    }

    public String getSubprotocolHandler() {
        return this.subprotocolHandler;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public String getPipelineHandler() {
        return this.pipelineHandler;
    }

    public String getDispatchToCustomSequence() {
        return this.dispatchToCustomSequence;
    }

    public boolean isUsePortOffset() {
        return this.usePortOffset;
    }

    public int getInflowIdleTime() {
        return this.inflowIdleTime;
    }

    public int getOutflowIdleTime() {
        return this.outflowIdleTime;
    }

    public static class InboundWebsocketConfigurationBuilder {
        private final int port;
        private final String name;
        private String bossThreadPoolSize;
        private String workerThreadPoolSize;
        private int broadcastLevel;
        private String outFlowDispatchSequence;
        private String outFlowErrorSequence;
        private String subprotocolHandler;
        private String defaultContentType;
        private String pipelineHandler;
        private String dispatchToCustomSequence;
        private boolean usePortOffset = false;
        private int inflowIdleTime;
        private int outflowIdleTime;

        public InboundWebsocketConfigurationBuilder(int port, String name) {
            this.port = port;
            this.name = name;
        }

        public InboundWebsocketConfiguration build() {
            return new InboundWebsocketConfiguration(this);
        }

        public InboundWebsocketConfigurationBuilder bossThreadPoolSize(String bossThreadPoolSize) {
            this.bossThreadPoolSize = bossThreadPoolSize;
            return this;
        }

        public InboundWebsocketConfigurationBuilder workerThreadPoolSize(String workerThreadPoolSize) {
            this.workerThreadPoolSize = workerThreadPoolSize;
            return this;
        }

        public InboundWebsocketConfigurationBuilder broadcastLevel(int broadcastLevel) {
            this.broadcastLevel = broadcastLevel;
            return this;
        }

        public InboundWebsocketConfigurationBuilder outFlowDispatchSequence(String outFlowDispatchSequence) {
            this.outFlowDispatchSequence = outFlowDispatchSequence;
            return this;
        }

        public InboundWebsocketConfigurationBuilder outFlowErrorSequence(String outFlowErrorSequence) {
            this.outFlowErrorSequence = outFlowErrorSequence;
            return this;
        }

        public InboundWebsocketConfigurationBuilder subprotocolHandler(String subprotocolHandler) {
            this.subprotocolHandler = subprotocolHandler;
            return this;
        }

        public InboundWebsocketConfigurationBuilder defaultContentType(String defaultContentType) {
            this.defaultContentType = defaultContentType;
            return this;
        }

        public InboundWebsocketConfigurationBuilder pipelineHandler(String pipelineHandler) {
            this.pipelineHandler = pipelineHandler;
            return this;
        }

        public InboundWebsocketConfigurationBuilder dispatchToCustomSequence(String dispatchToCustomSequence) {
            this.dispatchToCustomSequence = dispatchToCustomSequence;
            return this;
        }

        public InboundWebsocketConfigurationBuilder usePortOffset(boolean usePortOffset) {
            this.usePortOffset = usePortOffset;
            return this;
        }

        public InboundWebsocketConfigurationBuilder inflowIdleTime(int inflowIdleTime) {
            this.inflowIdleTime = inflowIdleTime;
            return this;
        }

        public InboundWebsocketConfigurationBuilder outflowIdleTime(int outflowIdleTime) {
            this.outflowIdleTime = outflowIdleTime;
            return this;
        }
    }
}

