/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.Map;
import org.apache.commons.logging.Log;

public class WebsocketLogUtil {
    private static String getDirectionString(boolean isInbound) {
        if (isInbound) {
            return " >> ";
        }
        return " << ";
    }

    public static void printHeaders(Log log, FullHttpRequest msg, ChannelHandlerContext ctx) {
        String logStatement = WebsocketLogUtil.getDirectionString(true) + "Headers " + WebsocketLogUtil.resolveContextId(ctx) + " ";
        if (msg.headers() == null || msg.headers().isEmpty()) {
            log.debug((Object)(logStatement + "empty"));
        } else {
            log.debug((Object)("Inbound WebSocket request url: " + msg.getUri()));
            for (Map.Entry entry : msg.headers().entries()) {
                log.debug((Object)(logStatement + (String)entry.getKey() + ":" + (String)entry.getValue()));
            }
        }
    }

    public static void printWebSocketFrame(Log log, WebSocketFrame frame, ChannelHandlerContext ctx, String customMsg, boolean isInbound) {
        String channelContextId = WebsocketLogUtil.resolveContextId(ctx);
        WebsocketLogUtil.printWebSocketFrame(log, frame, channelContextId, customMsg, isInbound);
    }

    public static void printWebSocketFrame(Log log, WebSocketFrame frame, ChannelHandlerContext ctx, boolean isInbound) {
        String channelContextId = WebsocketLogUtil.resolveContextId(ctx);
        WebsocketLogUtil.printWebSocketFrame(log, frame, channelContextId, null, isInbound);
    }

    private static void printWebSocketFrame(Log log, WebSocketFrame frame, String channelContextId, String customMsg, boolean isInbound) {
        String logStatement = WebsocketLogUtil.getDirectionString(isInbound) + channelContextId;
        if (frame instanceof PingWebSocketFrame) {
            logStatement = logStatement + " Ping frame";
        } else if (frame instanceof PongWebSocketFrame) {
            logStatement = logStatement + " Pong frame";
        } else if (frame instanceof CloseWebSocketFrame) {
            logStatement = logStatement + " Close frame";
        } else if (frame instanceof BinaryWebSocketFrame) {
            logStatement = logStatement + " Binary frame";
        } else if (frame instanceof TextWebSocketFrame) {
            logStatement = logStatement + " " + ((TextWebSocketFrame)frame).text();
        }
        if (customMsg != null) {
            logStatement = logStatement + " " + customMsg;
        }
        log.debug((Object)logStatement);
    }

    public static void printSpecificLog(Log log, ChannelHandlerContext ctx, String message) {
        log.debug((Object)(" " + message + " on Context id : " + ctx.channel().toString()));
    }

    private static String resolveContextId(ChannelHandlerContext ctx) {
        if (ctx == null || ctx.channel() == null) {
            return null;
        }
        return ctx.channel().toString();
    }
}

