/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.inboundfactory;

import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.apache.synapse.inbound.InboundRequestProcessorFactory;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericEventBasedConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericEventBasedListener;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericInboundListener;
import org.wso2.carbon.inbound.endpoint.protocol.generic.GenericProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.hl7.core.InboundHL7Listener;
import org.wso2.carbon.inbound.endpoint.protocol.http.InboundHttpListener;
import org.wso2.carbon.inbound.endpoint.protocol.https.InboundHttpsListener;
import org.wso2.carbon.inbound.endpoint.protocol.httpssecurewebsocket.InboundHttpsSecureWebsocketListener;
import org.wso2.carbon.inbound.endpoint.protocol.httpwebsocket.InboundHttpWebsocketListener;
import org.wso2.carbon.inbound.endpoint.protocol.jms.JMSProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.kafka.KAFKAProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.mqtt.MqttListener;
import org.wso2.carbon.inbound.endpoint.protocol.nats.InboundNatsListener;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQListener;
import org.wso2.carbon.inbound.endpoint.protocol.securewebsocket.InboundSecureWebsocketListener;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.InboundWebsocketListener;

public class InboundRequestProcessorFactoryImpl
implements InboundRequestProcessorFactory {
    public InboundRequestProcessor createInboundProcessor(InboundProcessorParams params) {
        String protocol = params.getProtocol();
        Object inboundRequestProcessor = null;
        if (protocol != null) {
            switch (Protocols.valueOf(protocol)) {
                case jms: {
                    inboundRequestProcessor = new JMSProcessor(params);
                    break;
                }
                case http: {
                    inboundRequestProcessor = new InboundHttpListener(params);
                    break;
                }
                case https: {
                    inboundRequestProcessor = new InboundHttpsListener(params);
                    break;
                }
                case ws: {
                    inboundRequestProcessor = new InboundWebsocketListener(params);
                    break;
                }
                case wss: {
                    inboundRequestProcessor = new InboundSecureWebsocketListener(params);
                    break;
                }
                case hl7: {
                    inboundRequestProcessor = new InboundHL7Listener(params);
                    break;
                }
                case kafka: {
                    inboundRequestProcessor = new KAFKAProcessor(params);
                    break;
                }
                case mqtt: {
                    inboundRequestProcessor = new MqttListener(params);
                    break;
                }
                case rabbitmq: {
                    inboundRequestProcessor = new RabbitMQListener(params);
                    break;
                }
                case nats: {
                    inboundRequestProcessor = new InboundNatsListener(params);
                    break;
                }
                case httpws: {
                    inboundRequestProcessor = new InboundHttpWebsocketListener(params);
                    break;
                }
                case httpswss: {
                    inboundRequestProcessor = new InboundHttpsSecureWebsocketListener(params);
                }
            }
        } else if (params.getClassImpl() != null) {
            inboundRequestProcessor = GenericInboundListener.isListeningInboundEndpoint(params) ? GenericInboundListener.getInstance(params) : (GenericEventBasedConsumer.isEventBasedInboundEndpoint(params) ? new GenericEventBasedListener(params) : new GenericProcessor(params));
        } else {
            throw new SynapseException("Protocol or Class should be specified for Inbound Endpoint " + params.getName());
        }
        return inboundRequestProcessor;
    }

    public static enum Protocols {
        jms,
        file,
        http,
        https,
        hl7,
        kafka,
        mqtt,
        rabbitmq,
        ws,
        wss,
        nats,
        httpws,
        httpswss;

    }
}

