/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.internal.http.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URITemplateHelper;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.RESTUtils;
import org.wso2.carbon.inbound.endpoint.internal.http.api.APIResource;
import org.wso2.carbon.inbound.endpoint.internal.http.api.InternalAPI;
import org.wso2.carbon.inbound.endpoint.internal.http.api.InternalAPIHandler;

public class InternalAPIDispatcher {
    private static Log log = LogFactory.getLog(InternalAPIDispatcher.class);
    private List<InternalAPI> internalApis;

    public InternalAPIDispatcher(List<InternalAPI> internalApis) {
        this.internalApis = internalApis;
    }

    public boolean dispatch(org.apache.synapse.MessageContext synCtx) {
        APIResource resource;
        InternalAPI internalApi = this.findAPI(synCtx);
        if (internalApi == null) {
            log.warn((Object)"No Internal API found to dispatch the message");
            return false;
        }
        List<InternalAPIHandler> handlerList = internalApi.getHandlers();
        if (handlerList != null) {
            for (InternalAPIHandler handler : handlerList) {
                Boolean success = handler.invoke(synCtx);
                if (success.booleanValue()) continue;
                return false;
            }
        }
        if ((resource = this.findResource(synCtx, internalApi)) == null) {
            log.warn((Object)("No matching Resource found in " + internalApi.getName() + " InternalAPI to dispatch the message"));
            return false;
        }
        return resource.invoke(synCtx);
    }

    private InternalAPI findAPI(org.apache.synapse.MessageContext synCtx) {
        for (InternalAPI internalApi : this.internalApis) {
            String context = internalApi.getContext();
            String path = RESTUtils.getFullRequestPath((org.apache.synapse.MessageContext)synCtx);
            if (!path.startsWith(context + "/") && !path.startsWith(context + "?") && !context.equals(path)) continue;
            return internalApi;
        }
        return null;
    }

    private APIResource findResource(org.apache.synapse.MessageContext synCtx, InternalAPI internalApi) {
        MessageContext axis2Ctx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String method = (String)axis2Ctx.getProperty("HTTP_METHOD");
        String path = (String)synCtx.getProperty("REST_FULL_REQUEST_PATH");
        String subPath = path.substring(internalApi.getContext().length());
        if ("".equals(subPath)) {
            subPath = "/";
        }
        for (APIResource resource : internalApi.getResources()) {
            if (!resource.getMethods().contains(method)) continue;
            DispatcherHelper helper = resource.getDispatcherHelper();
            URITemplateHelper templateHelper = (URITemplateHelper)helper;
            HashMap variables = new HashMap();
            if (!templateHelper.getUriTemplate().matches(subPath, variables)) continue;
            for (Map.Entry entry : variables.entrySet()) {
                synCtx.setProperty("uri.var." + (String)entry.getKey(), entry.getValue());
            }
            RESTUtils.populateQueryParamsToMessageContext((org.apache.synapse.MessageContext)synCtx);
            return resource;
        }
        return null;
    }
}

