/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.http;

import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.api.ApiConstants;
import org.apache.synapse.api.inbound.InboundApiHandler;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ResponseState;
import org.apache.synapse.core.axis2.SynapseMessageReceiver;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.rest.RESTRequestHandler;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.apache.synapse.transport.passthru.ServerWorker;
import org.apache.synapse.transport.passthru.SourceRequest;
import org.apache.synapse.transport.passthru.config.SourceConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.inbound.endpoint.protocol.http.InboundHttpResponseSender;
import org.wso2.carbon.inbound.endpoint.protocol.http.management.HTTPEndpointManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class InboundHttpServerWorker
extends ServerWorker {
    private static final Log log = LogFactory.getLog(InboundHttpServerWorker.class);
    private SourceRequest request;
    private int port;
    private String tenantDomain;
    private InboundApiHandler inboundApiHandler;
    private RESTRequestHandler restHandler;
    private Pattern dispatchPattern;
    private Matcher patternMatcher;
    private boolean isInternalHttpInboundEndpoint;
    private boolean isInternalHttpsInboundEndpoint;

    public InboundHttpServerWorker(int port, String tenantDomain, SourceRequest sourceRequest, SourceConfiguration sourceConfiguration, OutputStream outputStream) {
        super(sourceRequest, sourceConfiguration, outputStream);
        this.request = sourceRequest;
        this.port = port;
        this.tenantDomain = tenantDomain;
        this.inboundApiHandler = new InboundApiHandler();
        this.restHandler = new RESTRequestHandler();
        this.isInternalHttpInboundEndpoint = HTTPEndpointManager.getInstance().getInternalInboundHttpPort() == port;
        this.isInternalHttpsInboundEndpoint = HTTPEndpointManager.getInstance().getInternalInboundHttpsPort() == port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.request != null) {
            try {
                InboundEndpoint endpoint;
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.tenantDomain, true);
                MessageContext axis2MsgContext = this.getRequestContext();
                org.apache.synapse.MessageContext synCtx = this.createSynapseMessageContext(this.request, axis2MsgContext);
                this.updateAxis2MessageContextForSynapse(synCtx);
                this.setInboundProperties(synCtx);
                synCtx.setProperty("__SYNAPSE_RESPONSE_STATE__", (Object)new ResponseState());
                String method = this.request.getRequest() != null ? this.request.getRequest().getRequestLine().getMethod().toUpperCase() : "";
                this.processHttpRequestUri(axis2MsgContext, method);
                if (this.isInternalHttpInboundEndpoint) {
                    this.doPreInjectTasks(axis2MsgContext, (Axis2MessageContext)synCtx, method);
                    boolean result = HTTPEndpointManager.getInstance().getInternalHttpApiDispatcher().dispatch(synCtx);
                    this.respond(synCtx, result);
                    return;
                }
                if (this.isInternalHttpsInboundEndpoint) {
                    this.doPreInjectTasks(axis2MsgContext, (Axis2MessageContext)synCtx, method);
                    boolean result = HTTPEndpointManager.getInstance().getInternalHttpsApiDispatcher().dispatch(synCtx);
                    this.respond(synCtx, result);
                    return;
                }
                String endpointName = HTTPEndpointManager.getInstance().getEndpointName(this.port, this.tenantDomain);
                if (endpointName == null) {
                    this.handleException("Endpoint not found for port : " + this.port + " tenant domain : " + this.tenantDomain);
                }
                if ((endpoint = synCtx.getConfiguration().getInboundEndpoint(endpointName)) == null) {
                    log.error((Object)("Cannot find deployed inbound endpoint " + endpointName + "for process request"));
                    return;
                }
                CustomLogSetter.getInstance().setLogAppender(endpoint.getArtifactContainerName());
                this.doPreInjectTasks(axis2MsgContext, (Axis2MessageContext)synCtx, method);
                synCtx.setProperty(ApiConstants.API_CALLER, (Object)endpoint.getName());
                boolean isProcessed = this.inboundApiHandler.process(synCtx);
                if (!isProcessed) {
                    this.dispatchPattern = HTTPEndpointManager.getInstance().getPattern(this.tenantDomain, this.port);
                    boolean continueDispatch = true;
                    if (this.dispatchPattern != null) {
                        this.patternMatcher = this.dispatchPattern.matcher(this.request.getUri());
                        if (!this.patternMatcher.matches()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Requested URI does not match given dispatch regular expression.");
                            }
                            continueDispatch = false;
                        }
                    }
                    if (continueDispatch && this.dispatchPattern != null) {
                        boolean processedByAPI = false;
                        Set properties = synCtx.getPropertyKeySet();
                        if (properties != null) {
                            properties.remove(ApiConstants.API_CALLER);
                        }
                        processedByAPI = this.restHandler.process(synCtx);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Dispatch to API state : enabled, Message is " + (!processedByAPI ? "NOT" : "") + "processed by an API"));
                        }
                        if (!processedByAPI) {
                            boolean isAxis2Path = this.isAllowedAxis2Path(synCtx);
                            if (isAxis2Path) {
                                axis2MsgContext = this.createMessageContext(null, this.request);
                                this.processHttpRequestUri(axis2MsgContext, method);
                                this.setInboundProperties(axis2MsgContext);
                                if (!this.isRESTRequest(axis2MsgContext, method)) {
                                    if (this.request.isEntityEnclosing()) {
                                        this.processEntityEnclosingRequest(axis2MsgContext, isAxis2Path);
                                    } else {
                                        this.processNonEntityEnclosingRESTHandler(null, axis2MsgContext, isAxis2Path);
                                    }
                                } else {
                                    String contentTypeHeader = (String)this.request.getHeaders().get("Content-Type");
                                    SOAPEnvelope soapEnvelope = this.handleRESTUrlPost(contentTypeHeader);
                                    this.processNonEntityEnclosingRESTHandler(soapEnvelope, axis2MsgContext, true);
                                }
                            } else {
                                this.injectToMainSequence(synCtx, endpoint);
                            }
                        }
                    } else if (continueDispatch && this.dispatchPattern == null) {
                        this.injectToSequence(synCtx, endpoint);
                    } else {
                        this.injectToMainSequence(synCtx, endpoint);
                    }
                }
                SynapseMessageReceiver.doPostInjectUpdates((org.apache.synapse.MessageContext)synCtx);
                this.sendAck(axis2MsgContext);
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred when running " + InboundHttpServerWorker.class.getName()), (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            log.error((Object)"InboundSourceRequest cannot be null");
        }
    }

    private void doPreInjectTasks(MessageContext axis2MsgContext, Axis2MessageContext synCtx, String method) {
        if (!this.isRESTRequest(axis2MsgContext, method)) {
            if (this.request.isEntityEnclosing()) {
                this.processEntityEnclosingRequest(axis2MsgContext, false);
            } else {
                this.processNonEntityEnclosingRESTHandler(null, axis2MsgContext, false);
            }
        } else {
            AxisOperation axisOperation = synCtx.getAxis2MessageContext().getAxisOperation();
            synCtx.getAxis2MessageContext().setAxisOperation(null);
            String contentTypeHeader = (String)this.request.getHeaders().get("Content-Type");
            SOAPEnvelope soapEnvelope = this.handleRESTUrlPost(contentTypeHeader);
            this.processNonEntityEnclosingRESTHandler(soapEnvelope, axis2MsgContext, false);
            synCtx.getAxis2MessageContext().setAxisOperation(axisOperation);
        }
    }

    private void injectToMainSequence(org.apache.synapse.MessageContext synCtx, InboundEndpoint endpoint) {
        SequenceMediator injectingSequence = (SequenceMediator)synCtx.getMainSequence();
        SequenceMediator faultSequence = this.getFaultSequence(synCtx, endpoint);
        MediatorFaultHandler mediatorFaultHandler = new MediatorFaultHandler((Mediator)faultSequence);
        synCtx.pushFaultHandler((FaultHandler)mediatorFaultHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("injecting message to sequence : " + endpoint.getInjectingSeq()));
        }
        synCtx.getEnvironment().injectMessage(synCtx, injectingSequence);
    }

    private void injectToSequence(org.apache.synapse.MessageContext synCtx, InboundEndpoint endpoint) {
        SequenceMediator injectingSequence = null;
        if (endpoint.getInjectingSeq() != null) {
            injectingSequence = (SequenceMediator)synCtx.getSequence(endpoint.getInjectingSeq());
        }
        if (injectingSequence == null) {
            injectingSequence = (SequenceMediator)synCtx.getMainSequence();
        }
        SequenceMediator faultSequence = this.getFaultSequence(synCtx, endpoint);
        MediatorFaultHandler mediatorFaultHandler = new MediatorFaultHandler((Mediator)faultSequence);
        synCtx.pushFaultHandler((FaultHandler)mediatorFaultHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)("injecting message to sequence : " + endpoint.getInjectingSeq()));
        }
        synCtx.setProperty("inbound.endpoint.name", (Object)endpoint.getName());
        synCtx.setProperty("ARTIFACT_NAME", (Object)("inboundendpoint" + endpoint.getName()));
        synCtx.getEnvironment().injectMessage(synCtx, injectingSequence);
    }

    private SequenceMediator getFaultSequence(org.apache.synapse.MessageContext synCtx, InboundEndpoint endpoint) {
        SequenceMediator faultSequence = null;
        if (endpoint.getOnErrorSeq() != null) {
            faultSequence = (SequenceMediator)synCtx.getSequence(endpoint.getOnErrorSeq());
        }
        if (faultSequence == null) {
            faultSequence = (SequenceMediator)synCtx.getFaultSequence();
        }
        return faultSequence;
    }

    private void setInboundProperties(org.apache.synapse.MessageContext msgContext) {
        msgContext.setProperty("isInbound", (Object)true);
        msgContext.setProperty("inbound-response-worker", (Object)new InboundHttpResponseSender());
        msgContext.setWSAAction((String)this.request.getHeaders().get("SOAPAction"));
    }

    private void setInboundProperties(MessageContext axis2Context) {
        axis2Context.setProperty("isInbound", (Object)true);
    }

    protected void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private boolean isAllowedAxis2Path(org.apache.synapse.MessageContext synapseMsgContext) {
        String serviceOpPart;
        boolean isProxy = false;
        String reqUri = this.request.getUri();
        String tenant = MultitenantUtils.getTenantDomainFromUrl((String)this.request.getUri());
        String servicePath = this.getSourceConfiguration().getConfigurationContext().getServicePath();
        if (!reqUri.equalsIgnoreCase(tenant)) {
            servicePath = servicePath + "/t/" + tenant;
        }
        if ((serviceOpPart = Utils.getServiceAndOperationPart((String)reqUri, (String)servicePath)) != null) {
            isProxy = this.isProxyDeployed(synapseMsgContext, serviceOpPart);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Requested Proxy Service '" + serviceOpPart + "' is not deployed"));
        }
        return isProxy;
    }

    private boolean isProxyDeployed(org.apache.synapse.MessageContext synapseContext, String serviceOpPart) {
        boolean isDeployed = false;
        String proxyName = serviceOpPart.split("/")[0];
        if (synapseContext.getConfiguration().getProxyService(proxyName) != null) {
            isDeployed = true;
        }
        return isDeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.synapse.MessageContext createSynapseMessageContext(SourceRequest inboundSourceRequest, MessageContext axis2Context) throws AxisFault {
        MessageContext axis2MsgCtx = axis2Context;
        if (!this.tenantDomain.equals("carbon.super")) {
            try {
                ConfigurationContext tenantConfigCtx = null;
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    privilegedCarbonContext.setTenantDomain(this.tenantDomain, true);
                    tenantConfigCtx = TenantAxisUtils.getTenantConfigurationContext((String)this.tenantDomain, (ConfigurationContext)axis2MsgCtx.getConfigurationContext());
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                axis2MsgCtx.setConfigurationContext(tenantConfigCtx);
                axis2MsgCtx.setProperty("tenantDomain", (Object)this.tenantDomain);
            }
            catch (Exception e) {
                log.warn((Object)("Could not get tenant configuration context for tenant " + this.tenantDomain + ". Tenant may not exist. Message will be dispatched to super tenant."));
                this.tenantDomain = "carbon.super";
            }
        }
        return MessageContextCreatorForAxis2.getSynapseMessageContext((MessageContext)axis2MsgCtx);
    }

    private org.apache.synapse.MessageContext updateAxis2MessageContextForSynapse(org.apache.synapse.MessageContext synCtx) throws AxisFault {
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setServiceContext(svcCtx);
        ((Axis2MessageContext)synCtx).getAxis2MessageContext().setOperationContext(opCtx);
        return synCtx;
    }

    private void respond(org.apache.synapse.MessageContext synCtx, boolean result) {
        synCtx.setTo(null);
        synCtx.setResponse(true);
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        axis2MessageCtx.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        if (!result && axis2MessageCtx.getProperty("HTTP_SC") == null) {
            axis2MessageCtx.setProperty("HTTP_SC", (Object)"404");
        }
        Axis2Sender.sendBack((org.apache.synapse.MessageContext)synCtx);
    }
}

