/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.http.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkerPoolConfiguration {
    private static final Log log = LogFactory.getLog(WorkerPoolConfiguration.class);
    private int workerPoolCoreSize;
    private int workerPoolSizeMax;
    private int workerPoolThreadKeepAliveSec;
    private int workerPoolQueuLength;
    private String threadGroupID;
    private String threadID;

    public WorkerPoolConfiguration(String workerPoolCoreSize, String workerPoolSizeMax, String workerPoolThreadKeepAliveSec, String workerPoolQueuLength, String threadGroupID, String threadID) {
        try {
            if (workerPoolCoreSize != null && !"".equals(workerPoolCoreSize.trim())) {
                this.workerPoolCoreSize = Integer.parseInt(workerPoolCoreSize);
            }
            if (workerPoolSizeMax != null && !"".equals(workerPoolSizeMax.trim())) {
                this.workerPoolSizeMax = Integer.parseInt(workerPoolSizeMax);
            }
            if (workerPoolThreadKeepAliveSec != null && !"".equals(workerPoolThreadKeepAliveSec.trim())) {
                this.workerPoolThreadKeepAliveSec = Integer.parseInt(workerPoolThreadKeepAliveSec);
            }
            if (workerPoolQueuLength != null && !"".equals(workerPoolQueuLength.trim())) {
                this.workerPoolQueuLength = Integer.parseInt(workerPoolQueuLength);
            }
            this.threadGroupID = threadGroupID != null && !"".equals(threadGroupID.trim()) ? threadGroupID : "Pass-Through Inbound WorkerThread Group";
            this.threadID = threadID != null && !"".equals(threadID.trim()) ? threadID : "PassThroughInboundWorkerThread";
        }
        catch (Exception e) {
            log.error((Object)"Please Provide int value for worker pool configuration", (Throwable)e);
        }
    }

    public int getWorkerPoolCoreSize() {
        return this.workerPoolCoreSize;
    }

    public int getWorkerPoolSizeMax() {
        return this.workerPoolSizeMax;
    }

    public int getWorkerPoolThreadKeepAliveSec() {
        return this.workerPoolThreadKeepAliveSec;
    }

    public String getThreadGroupID() {
        return this.threadGroupID;
    }

    public String getThreadID() {
        return this.threadID;
    }

    public int getWorkerPoolQueuLength() {
        return this.workerPoolQueuLength;
    }
}

