/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.nats;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsMessageListener;
import org.wso2.carbon.inbound.endpoint.protocol.nats.TLSConnection;

public class CoreListener
implements NatsMessageListener {
    private static final Log log = LogFactory.getLog((String)CoreListener.class.getName());
    private String subject;
    private NatsInjectHandler injectHandler;
    private Properties natsProperties;
    private Connection connection;

    public CoreListener(String subject, NatsInjectHandler injectHandler, Properties natsProperties) {
        this.subject = subject;
        this.injectHandler = injectHandler;
        this.natsProperties = natsProperties;
    }

    @Override
    public boolean createConnection() throws IOException, InterruptedException {
        if (this.connection == null) {
            this.connection = this.getNatsConnection();
        }
        return true;
    }

    public Connection getNatsConnection() throws IOException, InterruptedException {
        SSLContext sslContext;
        String bufferSize = this.natsProperties.getProperty("buffer.size");
        String turnOnAdvancedStats = this.natsProperties.getProperty("turn.on.advanced.stats");
        String traceConnection = this.natsProperties.getProperty("trace.connection");
        String tlsProtocol = this.validateParameter(this.natsProperties.getProperty("tls.protocol"));
        String tlsKeyStoreType = this.validateParameter(this.natsProperties.getProperty("tls.keystore.type"));
        String tlsKeyStoreLocation = this.validateParameter(this.natsProperties.getProperty("tls.keystore.location"));
        String tlsKeyStorePassword = this.validateParameter(this.natsProperties.getProperty("tls.keystore.password"));
        String tlsTrustStoreType = this.validateParameter(this.natsProperties.getProperty("tls.truststore.type"));
        String tlsTrustStoreLocation = this.validateParameter(this.natsProperties.getProperty("tls.truststore.location"));
        String tlsTrustStorePassword = this.validateParameter(this.natsProperties.getProperty("tls.truststore.password"));
        String tlsKeyManagerAlgorithm = this.validateParameter(this.natsProperties.getProperty("tls.key.manager.algorithm"));
        String tlsTrustManagerAlgorithm = this.validateParameter(this.natsProperties.getProperty("tls.trust.manager.algorithm"));
        Options.Builder builder = new Options.Builder(this.natsProperties);
        if (StringUtils.isNotEmpty((String)bufferSize)) {
            builder.bufferSize(Integer.parseInt(bufferSize));
        }
        if (Boolean.parseBoolean(turnOnAdvancedStats)) {
            builder.turnOnAdvancedStats();
        }
        if (Boolean.parseBoolean(traceConnection)) {
            builder.traceConnection();
        }
        if (StringUtils.isNotEmpty((String)(tlsProtocol + tlsTrustStoreType + tlsTrustStoreLocation + tlsTrustStorePassword + tlsKeyStoreType + tlsKeyStoreLocation + tlsKeyStorePassword + tlsKeyManagerAlgorithm + tlsTrustManagerAlgorithm)) && (sslContext = CoreListener.createSSLContext(new TLSConnection(tlsProtocol, tlsTrustStoreType, tlsTrustStoreLocation, tlsTrustStorePassword, tlsKeyStoreType, tlsKeyStoreLocation, tlsKeyStorePassword, tlsKeyManagerAlgorithm, tlsTrustManagerAlgorithm))) != null) {
            builder.sslContext(sslContext);
        }
        return Nats.connect((Options)builder.build());
    }

    @Override
    public void initializeConsumer(String sequenceName) throws IOException, InterruptedException {
        if (this.createConnection()) {
            Dispatcher dispatcher = this.connection.createDispatcher(natsMessage -> {
                if (natsMessage != null) {
                    String message = new String(natsMessage.getData(), StandardCharsets.UTF_8);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message Received to NATS Inbound EP: " + message));
                    }
                    this.injectHandler.invoke(message.getBytes(), sequenceName, natsMessage.getReplyTo(), this.connection);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Message is null.");
                }
            });
            String queueGroup = this.natsProperties.getProperty("queue.group");
            if (StringUtils.isNotEmpty((String)queueGroup)) {
                dispatcher.subscribe(this.subject, queueGroup);
            } else {
                dispatcher.subscribe(this.subject);
            }
        }
    }

    @Override
    public void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"An error occurred while closing the connection. ", (Throwable)e);
        }
        this.connection = null;
    }

    private String validateParameter(String parameter) {
        return StringUtils.isEmpty((String)parameter) ? "" : parameter;
    }

    private static SSLContext createSSLContext(TLSConnection tlsConnection) {
        try {
            KeyManagerFactory keyManagerFactory = null;
            if (StringUtils.isNotEmpty((String)tlsConnection.getKeyStoreLocation())) {
                KeyStore keyStore = CoreListener.loadKeyStore(tlsConnection.getKeyStoreType(), tlsConnection.getKeyStoreLocation(), tlsConnection.getTrustStorePassword());
                keyManagerFactory = KeyManagerFactory.getInstance(tlsConnection.getKeyManagerAlgorithm().equals("") ? "SunX509" : tlsConnection.getKeyManagerAlgorithm());
                keyManagerFactory.init(keyStore, tlsConnection.getKeyStorePassword().toCharArray());
            }
            KeyStore trustStore = CoreListener.loadKeyStore(tlsConnection.getTrustStoreType(), tlsConnection.getTrustStoreLocation(), tlsConnection.getTrustStorePassword());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tlsConnection.getTrustManagerAlgorithm().equals("") ? "SunX509" : tlsConnection.getTrustManagerAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(tlsConnection.getProtocol().equals("") ? "TLSv1.2" : tlsConnection.getProtocol());
            sslContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error((Object)"Invalid TLS parameters. Establishing connection without TLS if possible.", (Throwable)e);
            return null;
        }
    }

    private static KeyStore loadKeyStore(String storeType, String storeLocation, String trustStorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore store = KeyStore.getInstance(storeType.equals("") ? "JKS" : storeType);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(storeLocation));){
            store.load(in, trustStorePassword.toCharArray());
        }
        return store;
    }
}

