/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.nats;

import io.nats.client.Connection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsReplySender;

public class NatsInjectHandler {
    private static final Log log = LogFactory.getLog(NatsInjectHandler.class);
    private String injectingSeq;
    private String onErrorSeq;
    private boolean sequential;
    private SynapseEnvironment synapseEnvironment;
    private String contentType;
    private SequenceMediator seq;

    public NatsInjectHandler(String injectingSeq, String onErrorSeq, boolean sequential, SynapseEnvironment synapseEnvironment, String contentType) {
        this.injectingSeq = injectingSeq;
        this.onErrorSeq = onErrorSeq;
        this.sequential = sequential;
        this.synapseEnvironment = synapseEnvironment;
        this.contentType = contentType;
        this.seq = (SequenceMediator)synapseEnvironment.getSynapseConfiguration().getSequence(injectingSeq);
    }

    public boolean invoke(Object object, String name, String replyTo, Connection connection) throws SynapseException {
        try {
            org.apache.synapse.MessageContext msgCtx = this.createMessageContext();
            msgCtx.setProperty("inbound.endpoint.name", (Object)name);
            msgCtx.setProperty("isInbound", (Object)true);
            InboundEndpoint inboundEndpoint = msgCtx.getConfiguration().getInboundEndpoint(name);
            CustomLogSetter.getInstance().setLogAppender(inboundEndpoint.getArtifactContainerName());
            MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
            if (replyTo != null) {
                msgCtx.setProperty("inbound-response-worker", (Object)new NatsReplySender(replyTo, connection));
            }
            Builder builder = this.getMessageBuilder(axis2MsgCtx);
            AutoCloseInputStream in = new AutoCloseInputStream((InputStream)new ByteArrayInputStream((byte[])object));
            OMElement documentElement = builder.processDocument((InputStream)in, this.contentType, axis2MsgCtx);
            msgCtx.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)documentElement));
            if (this.seq != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Injecting message to sequence : " + this.injectingSeq));
                }
                if (!this.seq.isInitialized()) {
                    this.seq.init(this.synapseEnvironment);
                }
                this.seq.setErrorHandler(this.onErrorSeq);
                return this.synapseEnvironment.injectInbound(msgCtx, this.seq, this.sequential);
            }
            log.error((Object)("Sequence: " + this.injectingSeq + " not found"));
        }
        catch (AxisFault e) {
            throw new SynapseException("Error while processing the NATS Message", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processed NATS Message: " + new String((byte[])object)));
        }
        return true;
    }

    private Builder getMessageBuilder(MessageContext axis2MsgCtx) throws AxisFault {
        SOAPBuilder builder;
        if (this.contentType == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No content type specified. Using SOAP builder.");
            }
            builder = new SOAPBuilder();
        } else {
            int index = this.contentType.indexOf(59);
            String type = index > 0 ? this.contentType.substring(0, index) : this.contentType;
            builder = BuilderUtil.getBuilderFromSelector((String)type, (MessageContext)axis2MsgCtx);
            if (builder == null) {
                log.warn((Object)("No message builder found for type '" + type + "'. Falling back to SOAP."));
                builder = new SOAPBuilder();
            }
        }
        return builder;
    }

    private org.apache.synapse.MessageContext createMessageContext() {
        org.apache.synapse.MessageContext msgCtx = this.synapseEnvironment.createMessageContext();
        MessageContext axis2MsgCtx = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        axis2MsgCtx.setServerSide(true);
        axis2MsgCtx.setMessageID(UIDGenerator.generateUID());
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        axis2MsgCtx.setProperty("tenantDomain", (Object)carbonContext.getTenantDomain());
        msgCtx.setProperty("ClientApiNonBlocking", (Object)true);
        return msgCtx;
    }
}

