/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket.ssl;

import java.io.File;
import java.util.ArrayList;

public class InboundWebsocketSSLConfiguration {
    private File keyStore;
    private String keyStorePass;
    private String certPass;
    private File trustStore;
    private String trustStorePass;
    private String[] sslProtocols;
    private String[] cipherSuites;

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public void setSslProtocols(String[] sslProtocols) {
        this.sslProtocols = sslProtocols;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public InboundWebsocketSSLConfiguration(File keyStore, String keyStorePass) {
        this.keyStore = keyStore;
        this.keyStorePass = keyStorePass;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public InboundWebsocketSSLConfiguration setCertPass(String certPass) {
        this.certPass = certPass;
        return this;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public InboundWebsocketSSLConfiguration setTrustStore(File trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public InboundWebsocketSSLConfiguration setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
        return this;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public static class SSLConfigurationBuilder {
        private String keyStoreFile;
        private String keyStorePass;
        private String trustStoreFile;
        private String trustStorePass;
        private String certPass;
        private String sslProtocols;
        private String cipherSuites;

        public SSLConfigurationBuilder(String keyStoreFile, String keyStorePass, String trustStoreFile, String trustStorePass, String certPass) {
            this.keyStoreFile = keyStoreFile;
            this.keyStorePass = keyStorePass;
            this.trustStoreFile = trustStoreFile;
            this.trustStorePass = trustStorePass;
            this.certPass = certPass;
        }

        public SSLConfigurationBuilder(String keyStoreFile, String keyStorePass, String trustStoreFile, String trustStorePass, String certPass, String sslProtocols, String cipherSuites) {
            this.keyStoreFile = keyStoreFile;
            this.keyStorePass = keyStorePass;
            this.trustStoreFile = trustStoreFile;
            this.trustStorePass = trustStorePass;
            this.certPass = certPass;
            this.sslProtocols = sslProtocols;
            this.cipherSuites = cipherSuites;
        }

        public InboundWebsocketSSLConfiguration build() {
            if (this.certPass == null) {
                this.certPass = this.keyStorePass;
            }
            if (this.keyStoreFile == null || this.keyStorePass == null) {
                throw new IllegalArgumentException("keyStoreFile or keyStorePass not defined ");
            }
            File keyStore = new File(this.keyStoreFile);
            if (!keyStore.exists()) {
                throw new IllegalArgumentException("KeyStore File " + this.keyStoreFile + " not found");
            }
            InboundWebsocketSSLConfiguration sslConfig = new InboundWebsocketSSLConfiguration(keyStore, this.keyStorePass).setCertPass(this.certPass);
            if (this.trustStoreFile != null) {
                File trustStore = new File(this.trustStoreFile);
                if (!trustStore.exists()) {
                    throw new IllegalArgumentException("trustStore File " + this.trustStoreFile + " not found");
                }
                if (this.trustStorePass == null) {
                    throw new IllegalArgumentException("trustStorePass is not defined ");
                }
                sslConfig.setTrustStore(trustStore).setTrustStorePass(this.trustStorePass);
            }
            if (this.sslProtocols == null || this.sslProtocols.trim().isEmpty()) {
                this.sslProtocols = "TLS";
            }
            String[] preferredSSLProtocols = this.sslProtocols.trim().split(",");
            ArrayList<String> protocolList = new ArrayList<String>(preferredSSLProtocols.length);
            for (String protocol : preferredSSLProtocols) {
                if (protocol.trim().isEmpty()) continue;
                protocolList.add(protocol.trim());
            }
            preferredSSLProtocols = protocolList.toArray(new String[protocolList.size()]);
            sslConfig.setSslProtocols(preferredSSLProtocols);
            if (this.cipherSuites != null && this.cipherSuites.trim().length() != 0) {
                String[] preferredCipherSuites = this.cipherSuites.trim().split(",");
                ArrayList<String> cipherSuiteList = new ArrayList<String>(preferredCipherSuites.length);
                for (String cipherSuite : preferredCipherSuites) {
                    if (cipherSuite.trim().isEmpty()) continue;
                    cipherSuiteList.add(cipherSuite.trim());
                }
                preferredCipherSuites = cipherSuiteList.toArray(new String[cipherSuiteList.size()]);
                sslConfig.setCipherSuites(preferredCipherSuites);
            }
            return sslConfig;
        }
    }
}

