/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class CarbonContextConfigurator
extends AbstractHandler {
    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        if (!(this.isDispatchingToSynapse(messageContext) || cc.getTenantDomain() == null && cc.getTenantId() == -1)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (messageContext.getTransportIn() != null && messageContext.getTransportIn().getName() != null && !messageContext.getTransportIn().getName().contains("http")) {
            cc.setTenantDomain("carbon.super");
            cc.setTenantId(-1234);
            return Handler.InvocationResponse.CONTINUE;
        }
        try {
            EndpointReference epr = messageContext.getTo();
            if (epr != null) {
                String to = epr.getAddress();
                if (to != null && to.indexOf("/t/") != -1) {
                    String str1 = to.substring(to.indexOf("/t/") + 3);
                    String domain = str1.substring(0, str1.indexOf("/"));
                    cc.setTenantDomain(domain, true);
                } else {
                    cc.setTenantDomain("carbon.super");
                    cc.setTenantId(-1234);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private boolean isDispatchingToSynapse(MessageContext messageContext) {
        AxisService axisService = messageContext.getAxisService();
        if (axisService != null) {
            if ("__SynapseService".equalsIgnoreCase(axisService.getName())) {
                return true;
            }
            Parameter val = axisService.getParameter("serviceType");
            if (val != null && val.getValue().toString().equalsIgnoreCase("Proxy")) {
                return true;
            }
        }
        return false;
    }
}

