/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseImportSerializer;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.APIRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ImportStore
extends AbstractStore<SynapseImport> {
    public ImportStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new APIRegistryStore(registry, configName);
        }
    }

    @Override
    protected String getFileName(SynapseImport synapseImport) {
        return synapseImport.getFileName();
    }

    @Override
    protected SynapseImport getObjectToPersist(String name, SynapseConfiguration config) {
        return (SynapseImport)config.getSynapseImports().get(name);
    }

    @Override
    protected OMElement saveToFile(SynapseImport synImport, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeImport(synImport, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the API: " + synImport.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected OMElement serialize(SynapseImport synImport) {
        new SynapseImportSerializer();
        return SynapseImportSerializer.serializeImport((SynapseImport)synImport);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File importsDirectory = new File(this.configPath, "imports");
        if (!importsDirectory.exists()) {
            return;
        }
        File importFile = new File(importsDirectory, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(importFile.getAbsolutePath());
        importFile.delete();
    }
}

